/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = SchemaExtension.Builder.class
)
public final class SchemaExtension {
  private final String schema;

  private final boolean required;

  private final Map<String, Object> additionalProperties;

  private SchemaExtension(String schema, boolean required,
      Map<String, Object> additionalProperties) {
    this.schema = schema;
    this.required = required;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("schema")
  public String getSchema() {
    return schema;
  }

  @JsonProperty("required")
  public boolean getRequired() {
    return required;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof SchemaExtension && equalTo((SchemaExtension) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(SchemaExtension other) {
    return schema.equals(other.schema) && required == other.required;
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.schema, this.required);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static SchemaStage builder() {
    return new Builder();
  }

  public interface SchemaStage {
    RequiredStage schema(@NotNull String schema);

    Builder from(SchemaExtension other);
  }

  public interface RequiredStage {
    _FinalStage required(boolean required);
  }

  public interface _FinalStage {
    SchemaExtension build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements SchemaStage, RequiredStage, _FinalStage {
    private String schema;

    private boolean required;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(SchemaExtension other) {
      schema(other.getSchema());
      required(other.getRequired());
      return this;
    }

    @java.lang.Override
    @JsonSetter("schema")
    public RequiredStage schema(@NotNull String schema) {
      this.schema = Objects.requireNonNull(schema, "schema must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("required")
    public _FinalStage required(boolean required) {
      this.required = required;
      return this;
    }

    @java.lang.Override
    public SchemaExtension build() {
      return new SchemaExtension(schema, required, additionalProperties);
    }
  }
}
