/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.scim.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = AuthenticationScheme.Builder.class
)
public final class AuthenticationScheme {
  private final String name;

  private final String description;

  private final String specUri;

  private final String type;

  private final boolean primary;

  private final Map<String, Object> additionalProperties;

  private AuthenticationScheme(String name, String description, String specUri, String type,
      boolean primary, Map<String, Object> additionalProperties) {
    this.name = name;
    this.description = description;
    this.specUri = specUri;
    this.type = type;
    this.primary = primary;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("specUri")
  public String getSpecUri() {
    return specUri;
  }

  @JsonProperty("type")
  public String getType() {
    return type;
  }

  @JsonProperty("primary")
  public boolean getPrimary() {
    return primary;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof AuthenticationScheme && equalTo((AuthenticationScheme) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(AuthenticationScheme other) {
    return name.equals(other.name) && description.equals(other.description) && specUri.equals(other.specUri) && type.equals(other.type) && primary == other.primary;
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.description, this.specUri, this.type, this.primary);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static NameStage builder() {
    return new Builder();
  }

  public interface NameStage {
    DescriptionStage name(@NotNull String name);

    Builder from(AuthenticationScheme other);
  }

  public interface DescriptionStage {
    SpecUriStage description(@NotNull String description);
  }

  public interface SpecUriStage {
    TypeStage specUri(@NotNull String specUri);
  }

  public interface TypeStage {
    PrimaryStage type(@NotNull String type);
  }

  public interface PrimaryStage {
    _FinalStage primary(boolean primary);
  }

  public interface _FinalStage {
    AuthenticationScheme build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements NameStage, DescriptionStage, SpecUriStage, TypeStage, PrimaryStage, _FinalStage {
    private String name;

    private String description;

    private String specUri;

    private String type;

    private boolean primary;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(AuthenticationScheme other) {
      name(other.getName());
      description(other.getDescription());
      specUri(other.getSpecUri());
      type(other.getType());
      primary(other.getPrimary());
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public DescriptionStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("description")
    public SpecUriStage description(@NotNull String description) {
      this.description = Objects.requireNonNull(description, "description must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("specUri")
    public TypeStage specUri(@NotNull String specUri) {
      this.specUri = Objects.requireNonNull(specUri, "specUri must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("type")
    public PrimaryStage type(@NotNull String type) {
      this.type = Objects.requireNonNull(type, "type must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("primary")
    public _FinalStage primary(boolean primary) {
      this.primary = primary;
      return this;
    }

    @java.lang.Override
    public AuthenticationScheme build() {
      return new AuthenticationScheme(name, description, specUri, type, primary, additionalProperties);
    }
  }
}
