/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.prompts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ChatMessage.Builder.class
)
public final class ChatMessage {
  private final String role;

  private final String content;

  private final Map<String, Object> additionalProperties;

  private ChatMessage(String role, String content, Map<String, Object> additionalProperties) {
    this.role = role;
    this.content = content;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("role")
  public String getRole() {
    return role;
  }

  @JsonProperty("content")
  public String getContent() {
    return content;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ChatMessage && equalTo((ChatMessage) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ChatMessage other) {
    return role.equals(other.role) && content.equals(other.content);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.role, this.content);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static RoleStage builder() {
    return new Builder();
  }

  public interface RoleStage {
    ContentStage role(@NotNull String role);

    Builder from(ChatMessage other);
  }

  public interface ContentStage {
    _FinalStage content(@NotNull String content);
  }

  public interface _FinalStage {
    ChatMessage build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements RoleStage, ContentStage, _FinalStage {
    private String role;

    private String content;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ChatMessage other) {
      role(other.getRole());
      content(other.getContent());
      return this;
    }

    @java.lang.Override
    @JsonSetter("role")
    public ContentStage role(@NotNull String role) {
      this.role = Objects.requireNonNull(role, "role must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("content")
    public _FinalStage content(@NotNull String content) {
      this.content = Objects.requireNonNull(content, "content must not be null");
      return this;
    }

    @java.lang.Override
    public ChatMessage build() {
      return new ChatMessage(role, content, additionalProperties);
    }
  }
}
