/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.prompts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ListPromptsMetaRequest.Builder.class
)
public final class ListPromptsMetaRequest {
  private final Optional<String> name;

  private final Optional<String> label;

  private final Optional<String> tag;

  private final Optional<Integer> page;

  private final Optional<Integer> limit;

  private final Optional<OffsetDateTime> fromUpdatedAt;

  private final Optional<OffsetDateTime> toUpdatedAt;

  private final Map<String, Object> additionalProperties;

  private ListPromptsMetaRequest(Optional<String> name, Optional<String> label,
      Optional<String> tag, Optional<Integer> page, Optional<Integer> limit,
      Optional<OffsetDateTime> fromUpdatedAt, Optional<OffsetDateTime> toUpdatedAt,
      Map<String, Object> additionalProperties) {
    this.name = name;
    this.label = label;
    this.tag = tag;
    this.page = page;
    this.limit = limit;
    this.fromUpdatedAt = fromUpdatedAt;
    this.toUpdatedAt = toUpdatedAt;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  @JsonProperty("label")
  public Optional<String> getLabel() {
    return label;
  }

  @JsonProperty("tag")
  public Optional<String> getTag() {
    return tag;
  }

  /**
   * @return page number, starts at 1
   */
  @JsonProperty("page")
  public Optional<Integer> getPage() {
    return page;
  }

  /**
   * @return limit of items per page
   */
  @JsonProperty("limit")
  public Optional<Integer> getLimit() {
    return limit;
  }

  /**
   * @return Optional filter to only include prompt versions created/updated on or after a certain datetime (ISO 8601)
   */
  @JsonProperty("fromUpdatedAt")
  public Optional<OffsetDateTime> getFromUpdatedAt() {
    return fromUpdatedAt;
  }

  /**
   * @return Optional filter to only include prompt versions created/updated before a certain datetime (ISO 8601)
   */
  @JsonProperty("toUpdatedAt")
  public Optional<OffsetDateTime> getToUpdatedAt() {
    return toUpdatedAt;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ListPromptsMetaRequest && equalTo((ListPromptsMetaRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ListPromptsMetaRequest other) {
    return name.equals(other.name) && label.equals(other.label) && tag.equals(other.tag) && page.equals(other.page) && limit.equals(other.limit) && fromUpdatedAt.equals(other.fromUpdatedAt) && toUpdatedAt.equals(other.toUpdatedAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.label, this.tag, this.page, this.limit, this.fromUpdatedAt, this.toUpdatedAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> name = Optional.empty();

    private Optional<String> label = Optional.empty();

    private Optional<String> tag = Optional.empty();

    private Optional<Integer> page = Optional.empty();

    private Optional<Integer> limit = Optional.empty();

    private Optional<OffsetDateTime> fromUpdatedAt = Optional.empty();

    private Optional<OffsetDateTime> toUpdatedAt = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ListPromptsMetaRequest other) {
      name(other.getName());
      label(other.getLabel());
      tag(other.getTag());
      page(other.getPage());
      limit(other.getLimit());
      fromUpdatedAt(other.getFromUpdatedAt());
      toUpdatedAt(other.getToUpdatedAt());
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @JsonSetter(
        value = "label",
        nulls = Nulls.SKIP
    )
    public Builder label(Optional<String> label) {
      this.label = label;
      return this;
    }

    public Builder label(String label) {
      this.label = Optional.ofNullable(label);
      return this;
    }

    @JsonSetter(
        value = "tag",
        nulls = Nulls.SKIP
    )
    public Builder tag(Optional<String> tag) {
      this.tag = tag;
      return this;
    }

    public Builder tag(String tag) {
      this.tag = Optional.ofNullable(tag);
      return this;
    }

    @JsonSetter(
        value = "page",
        nulls = Nulls.SKIP
    )
    public Builder page(Optional<Integer> page) {
      this.page = page;
      return this;
    }

    public Builder page(Integer page) {
      this.page = Optional.ofNullable(page);
      return this;
    }

    @JsonSetter(
        value = "limit",
        nulls = Nulls.SKIP
    )
    public Builder limit(Optional<Integer> limit) {
      this.limit = limit;
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = Optional.ofNullable(limit);
      return this;
    }

    @JsonSetter(
        value = "fromUpdatedAt",
        nulls = Nulls.SKIP
    )
    public Builder fromUpdatedAt(Optional<OffsetDateTime> fromUpdatedAt) {
      this.fromUpdatedAt = fromUpdatedAt;
      return this;
    }

    public Builder fromUpdatedAt(OffsetDateTime fromUpdatedAt) {
      this.fromUpdatedAt = Optional.ofNullable(fromUpdatedAt);
      return this;
    }

    @JsonSetter(
        value = "toUpdatedAt",
        nulls = Nulls.SKIP
    )
    public Builder toUpdatedAt(Optional<OffsetDateTime> toUpdatedAt) {
      this.toUpdatedAt = toUpdatedAt;
      return this;
    }

    public Builder toUpdatedAt(OffsetDateTime toUpdatedAt) {
      this.toUpdatedAt = Optional.ofNullable(toUpdatedAt);
      return this;
    }

    public ListPromptsMetaRequest build() {
      return new ListPromptsMetaRequest(name, label, tag, page, limit, fromUpdatedAt, toUpdatedAt, additionalProperties);
    }
  }
}
