/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.metrics.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = GetMetricsRequest.Builder.class
)
public final class GetMetricsRequest {
  private final String query;

  private final Map<String, Object> additionalProperties;

  private GetMetricsRequest(String query, Map<String, Object> additionalProperties) {
    this.query = query;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return JSON string containing the query parameters with the following structure:
   * <pre><code class="language-json">{
   *   &quot;view&quot;: string,           // Required. One of &quot;traces&quot;, &quot;observations&quot;, &quot;scores-numeric&quot;, &quot;scores-categorical&quot;
   *   &quot;dimensions&quot;: [           // Optional. Default: []
   *     {
   *       &quot;field&quot;: string       // Field to group by, e.g. &quot;name&quot;, &quot;userId&quot;, &quot;sessionId&quot;
   *     }
   *   ],
   *   &quot;metrics&quot;: [              // Required. At least one metric must be provided
   *     {
   *       &quot;measure&quot;: string,    // What to measure, e.g. &quot;count&quot;, &quot;latency&quot;, &quot;value&quot;
   *       &quot;aggregation&quot;: string // How to aggregate, e.g. &quot;count&quot;, &quot;sum&quot;, &quot;avg&quot;, &quot;p95&quot;, &quot;histogram&quot;
   *     }
   *   ],
   *   &quot;filters&quot;: [              // Optional. Default: []
   *     {
   *       &quot;column&quot;: string,     // Column to filter on
   *       &quot;operator&quot;: string,   // Operator, e.g. &quot;=&quot;, &quot;&gt;&quot;, &quot;&lt;&quot;, &quot;contains&quot;
   *       &quot;value&quot;: any,         // Value to compare against
   *       &quot;type&quot;: string,       // Data type, e.g. &quot;string&quot;, &quot;number&quot;, &quot;stringObject&quot;
   *       &quot;key&quot;: string         // Required only when filtering on metadata
   *     }
   *   ],
   *   &quot;timeDimension&quot;: {        // Optional. Default: null. If provided, results will be grouped by time
   *     &quot;granularity&quot;: string   // One of &quot;minute&quot;, &quot;hour&quot;, &quot;day&quot;, &quot;week&quot;, &quot;month&quot;, &quot;auto&quot;
   *   },
   *   &quot;fromTimestamp&quot;: string,  // Required. ISO datetime string for start of time range
   *   &quot;toTimestamp&quot;: string,    // Required. ISO datetime string for end of time range
   *   &quot;orderBy&quot;: [              // Optional. Default: null
   *     {
   *       &quot;field&quot;: string,      // Field to order by
   *       &quot;direction&quot;: string   // &quot;asc&quot; or &quot;desc&quot;
   *     }
   *   ],
   *   &quot;config&quot;: {               // Optional. Query-specific configuration
   *     &quot;bins&quot;: number,         // Optional. Number of bins for histogram (1-100), default: 10
   *     &quot;row_limit&quot;: number     // Optional. Row limit for results (1-1000)
   *   }
   * }
   * </code></pre>
   */
  @JsonProperty("query")
  public String getQuery() {
    return query;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof GetMetricsRequest && equalTo((GetMetricsRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(GetMetricsRequest other) {
    return query.equals(other.query);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.query);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static QueryStage builder() {
    return new Builder();
  }

  public interface QueryStage {
    _FinalStage query(@NotNull String query);

    Builder from(GetMetricsRequest other);
  }

  public interface _FinalStage {
    GetMetricsRequest build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements QueryStage, _FinalStage {
    private String query;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(GetMetricsRequest other) {
      query(other.getQuery());
      return this;
    }

    /**
     * <p>JSON string containing the query parameters with the following structure:</p>
     * <pre><code class="language-json">{
     *   &quot;view&quot;: string,           // Required. One of &quot;traces&quot;, &quot;observations&quot;, &quot;scores-numeric&quot;, &quot;scores-categorical&quot;
     *   &quot;dimensions&quot;: [           // Optional. Default: []
     *     {
     *       &quot;field&quot;: string       // Field to group by, e.g. &quot;name&quot;, &quot;userId&quot;, &quot;sessionId&quot;
     *     }
     *   ],
     *   &quot;metrics&quot;: [              // Required. At least one metric must be provided
     *     {
     *       &quot;measure&quot;: string,    // What to measure, e.g. &quot;count&quot;, &quot;latency&quot;, &quot;value&quot;
     *       &quot;aggregation&quot;: string // How to aggregate, e.g. &quot;count&quot;, &quot;sum&quot;, &quot;avg&quot;, &quot;p95&quot;, &quot;histogram&quot;
     *     }
     *   ],
     *   &quot;filters&quot;: [              // Optional. Default: []
     *     {
     *       &quot;column&quot;: string,     // Column to filter on
     *       &quot;operator&quot;: string,   // Operator, e.g. &quot;=&quot;, &quot;&gt;&quot;, &quot;&lt;&quot;, &quot;contains&quot;
     *       &quot;value&quot;: any,         // Value to compare against
     *       &quot;type&quot;: string,       // Data type, e.g. &quot;string&quot;, &quot;number&quot;, &quot;stringObject&quot;
     *       &quot;key&quot;: string         // Required only when filtering on metadata
     *     }
     *   ],
     *   &quot;timeDimension&quot;: {        // Optional. Default: null. If provided, results will be grouped by time
     *     &quot;granularity&quot;: string   // One of &quot;minute&quot;, &quot;hour&quot;, &quot;day&quot;, &quot;week&quot;, &quot;month&quot;, &quot;auto&quot;
     *   },
     *   &quot;fromTimestamp&quot;: string,  // Required. ISO datetime string for start of time range
     *   &quot;toTimestamp&quot;: string,    // Required. ISO datetime string for end of time range
     *   &quot;orderBy&quot;: [              // Optional. Default: null
     *     {
     *       &quot;field&quot;: string,      // Field to order by
     *       &quot;direction&quot;: string   // &quot;asc&quot; or &quot;desc&quot;
     *     }
     *   ],
     *   &quot;config&quot;: {               // Optional. Query-specific configuration
     *     &quot;bins&quot;: number,         // Optional. Number of bins for histogram (1-100), default: 10
     *     &quot;row_limit&quot;: number     // Optional. Row limit for results (1-1000)
     *   }
     * }
     * </code></pre>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("query")
    public _FinalStage query(@NotNull String query) {
      this.query = Objects.requireNonNull(query, "query must not be null");
      return this;
    }

    @java.lang.Override
    public GetMetricsRequest build() {
      return new GetMetricsRequest(query, additionalProperties);
    }
  }
}
