/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.langfuse.client.core.ObjectMappers;
import java.io.IOException;
import java.lang.IllegalArgumentException;
import java.lang.IllegalStateException;
import java.lang.Object;
import java.lang.String;
import java.util.Objects;
import com.langfuse.client.resources.commons.types.Usage;

@JsonDeserialize(
    using = IngestionUsage.Deserializer.class
)
public final class IngestionUsage {
  private final Object value;

  private final int type;

  private IngestionUsage(Object value, int type) {
    this.value = value;
    this.type = type;
  }

  @JsonValue
  public Object get() {
    return this.value;
  }

  public <T> T visit(Visitor<T> visitor) {
    if(this.type == 0) {
      return visitor.visit((Usage) this.value);
    } else if(this.type == 1) {
      return visitor.visit((OpenAiUsage) this.value);
    }
    throw new IllegalStateException("Failed to visit value. This should never happen.");
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof IngestionUsage && equalTo((IngestionUsage) other);
  }

  private boolean equalTo(IngestionUsage other) {
    return value.equals(other.value);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.value);
  }

  @java.lang.Override
  public String toString() {
    return this.value.toString();
  }

  public static IngestionUsage of(Usage value) {
    return new IngestionUsage(value, 0);
  }

  public static IngestionUsage of(OpenAiUsage value) {
    return new IngestionUsage(value, 1);
  }

  public interface Visitor<T> {
    T visit(Usage value);

    T visit(OpenAiUsage value);
  }

  static final class Deserializer extends StdDeserializer<IngestionUsage> {
    Deserializer() {
      super(IngestionUsage.class);
    }

    @java.lang.Override
    public IngestionUsage deserialize(JsonParser p, DeserializationContext context) throws
        IOException {
      Object value = p.readValueAs(Object.class);
      try {
        return of(ObjectMappers.JSON_MAPPER.convertValue(value, Usage.class));
      } catch(IllegalArgumentException e) {
      }
      try {
        return of(ObjectMappers.JSON_MAPPER.convertValue(value, OpenAiUsage.class));
      } catch(IllegalArgumentException e) {
      }
      throw new JsonParseException(p, "Failed to deserialize");
    }
  }
}
