/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = IngestionResponse.Builder.class
)
public final class IngestionResponse {
  private final List<IngestionSuccess> successes;

  private final List<IngestionError> errors;

  private final Map<String, Object> additionalProperties;

  private IngestionResponse(List<IngestionSuccess> successes, List<IngestionError> errors,
      Map<String, Object> additionalProperties) {
    this.successes = successes;
    this.errors = errors;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("successes")
  public List<IngestionSuccess> getSuccesses() {
    return successes;
  }

  @JsonProperty("errors")
  public List<IngestionError> getErrors() {
    return errors;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof IngestionResponse && equalTo((IngestionResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(IngestionResponse other) {
    return successes.equals(other.successes) && errors.equals(other.errors);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.successes, this.errors);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private List<IngestionSuccess> successes = new ArrayList<>();

    private List<IngestionError> errors = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(IngestionResponse other) {
      successes(other.getSuccesses());
      errors(other.getErrors());
      return this;
    }

    @JsonSetter(
        value = "successes",
        nulls = Nulls.SKIP
    )
    public Builder successes(List<IngestionSuccess> successes) {
      this.successes.clear();
      this.successes.addAll(successes);
      return this;
    }

    public Builder addSuccesses(IngestionSuccess successes) {
      this.successes.add(successes);
      return this;
    }

    public Builder addAllSuccesses(List<IngestionSuccess> successes) {
      this.successes.addAll(successes);
      return this;
    }

    @JsonSetter(
        value = "errors",
        nulls = Nulls.SKIP
    )
    public Builder errors(List<IngestionError> errors) {
      this.errors.clear();
      this.errors.addAll(errors);
      return this;
    }

    public Builder addErrors(IngestionError errors) {
      this.errors.add(errors);
      return this;
    }

    public Builder addAllErrors(List<IngestionError> errors) {
      this.errors.addAll(errors);
      return this;
    }

    public IngestionResponse build() {
      return new IngestionResponse(successes, errors, additionalProperties);
    }
  }
}
