/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = TraceWithFullDetails.Builder.class
)
public final class TraceWithFullDetails implements ITrace {
  private final String id;

  private final OffsetDateTime timestamp;

  private final Optional<String> name;

  private final Optional<Object> input;

  private final Optional<Object> output;

  private final Optional<String> sessionId;

  private final Optional<String> release;

  private final Optional<String> version;

  private final Optional<String> userId;

  private final Optional<Object> metadata;

  private final Optional<List<String>> tags;

  private final Optional<Boolean> public_;

  private final Optional<String> environment;

  private final String htmlPath;

  private final double latency;

  private final double totalCost;

  private final List<ObservationsView> observations;

  private final List<ScoreV1> scores;

  private final Map<String, Object> additionalProperties;

  private TraceWithFullDetails(String id, OffsetDateTime timestamp, Optional<String> name,
      Optional<Object> input, Optional<Object> output, Optional<String> sessionId,
      Optional<String> release, Optional<String> version, Optional<String> userId,
      Optional<Object> metadata, Optional<List<String>> tags, Optional<Boolean> public_,
      Optional<String> environment, String htmlPath, double latency, double totalCost,
      List<ObservationsView> observations, List<ScoreV1> scores,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.timestamp = timestamp;
    this.name = name;
    this.input = input;
    this.output = output;
    this.sessionId = sessionId;
    this.release = release;
    this.version = version;
    this.userId = userId;
    this.metadata = metadata;
    this.tags = tags;
    this.public_ = public_;
    this.environment = environment;
    this.htmlPath = htmlPath;
    this.latency = latency;
    this.totalCost = totalCost;
    this.observations = observations;
    this.scores = scores;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique identifier of a trace
   */
  @JsonProperty("id")
  @java.lang.Override
  public String getId() {
    return id;
  }

  /**
   * @return The timestamp when the trace was created
   */
  @JsonProperty("timestamp")
  @java.lang.Override
  public OffsetDateTime getTimestamp() {
    return timestamp;
  }

  /**
   * @return The name of the trace
   */
  @JsonProperty("name")
  @java.lang.Override
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The input data of the trace. Can be any JSON.
   */
  @JsonProperty("input")
  @java.lang.Override
  public Optional<Object> getInput() {
    return input;
  }

  /**
   * @return The output data of the trace. Can be any JSON.
   */
  @JsonProperty("output")
  @java.lang.Override
  public Optional<Object> getOutput() {
    return output;
  }

  /**
   * @return The session identifier associated with the trace
   */
  @JsonProperty("sessionId")
  @java.lang.Override
  public Optional<String> getSessionId() {
    return sessionId;
  }

  /**
   * @return The release version of the application when the trace was created
   */
  @JsonProperty("release")
  @java.lang.Override
  public Optional<String> getRelease() {
    return release;
  }

  /**
   * @return The version of the trace
   */
  @JsonProperty("version")
  @java.lang.Override
  public Optional<String> getVersion() {
    return version;
  }

  /**
   * @return The user identifier associated with the trace
   */
  @JsonProperty("userId")
  @java.lang.Override
  public Optional<String> getUserId() {
    return userId;
  }

  /**
   * @return The metadata associated with the trace. Can be any JSON.
   */
  @JsonProperty("metadata")
  @java.lang.Override
  public Optional<Object> getMetadata() {
    return metadata;
  }

  /**
   * @return The tags associated with the trace. Can be an array of strings or null.
   */
  @JsonProperty("tags")
  @java.lang.Override
  public Optional<List<String>> getTags() {
    return tags;
  }

  /**
   * @return Public traces are accessible via url without login
   */
  @JsonProperty("public")
  @java.lang.Override
  public Optional<Boolean> getPublic() {
    return public_;
  }

  /**
   * @return The environment from which this trace originated. Can be any lowercase alphanumeric string with hyphens and underscores that does not start with 'langfuse'.
   */
  @JsonProperty("environment")
  @java.lang.Override
  public Optional<String> getEnvironment() {
    return environment;
  }

  /**
   * @return Path of trace in Langfuse UI
   */
  @JsonProperty("htmlPath")
  public String getHtmlPath() {
    return htmlPath;
  }

  /**
   * @return Latency of trace in seconds
   */
  @JsonProperty("latency")
  public double getLatency() {
    return latency;
  }

  /**
   * @return Cost of trace in USD
   */
  @JsonProperty("totalCost")
  public double getTotalCost() {
    return totalCost;
  }

  /**
   * @return List of observations
   */
  @JsonProperty("observations")
  public List<ObservationsView> getObservations() {
    return observations;
  }

  /**
   * @return List of scores
   */
  @JsonProperty("scores")
  public List<ScoreV1> getScores() {
    return scores;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof TraceWithFullDetails && equalTo((TraceWithFullDetails) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(TraceWithFullDetails other) {
    return id.equals(other.id) && timestamp.equals(other.timestamp) && name.equals(other.name) && input.equals(other.input) && output.equals(other.output) && sessionId.equals(other.sessionId) && release.equals(other.release) && version.equals(other.version) && userId.equals(other.userId) && metadata.equals(other.metadata) && tags.equals(other.tags) && public_.equals(other.public_) && environment.equals(other.environment) && htmlPath.equals(other.htmlPath) && latency == other.latency && totalCost == other.totalCost && observations.equals(other.observations) && scores.equals(other.scores);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.timestamp, this.name, this.input, this.output, this.sessionId, this.release, this.version, this.userId, this.metadata, this.tags, this.public_, this.environment, this.htmlPath, this.latency, this.totalCost, this.observations, this.scores);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    TimestampStage id(@NotNull String id);

    Builder from(TraceWithFullDetails other);
  }

  public interface TimestampStage {
    HtmlPathStage timestamp(@NotNull OffsetDateTime timestamp);
  }

  public interface HtmlPathStage {
    LatencyStage htmlPath(@NotNull String htmlPath);
  }

  public interface LatencyStage {
    TotalCostStage latency(double latency);
  }

  public interface TotalCostStage {
    _FinalStage totalCost(double totalCost);
  }

  public interface _FinalStage {
    TraceWithFullDetails build();

    _FinalStage name(Optional<String> name);

    _FinalStage name(String name);

    _FinalStage input(Optional<Object> input);

    _FinalStage input(Object input);

    _FinalStage output(Optional<Object> output);

    _FinalStage output(Object output);

    _FinalStage sessionId(Optional<String> sessionId);

    _FinalStage sessionId(String sessionId);

    _FinalStage release(Optional<String> release);

    _FinalStage release(String release);

    _FinalStage version(Optional<String> version);

    _FinalStage version(String version);

    _FinalStage userId(Optional<String> userId);

    _FinalStage userId(String userId);

    _FinalStage metadata(Optional<Object> metadata);

    _FinalStage metadata(Object metadata);

    _FinalStage tags(Optional<List<String>> tags);

    _FinalStage tags(List<String> tags);

    _FinalStage public_(Optional<Boolean> public_);

    _FinalStage public_(Boolean public_);

    _FinalStage environment(Optional<String> environment);

    _FinalStage environment(String environment);

    _FinalStage observations(List<ObservationsView> observations);

    _FinalStage addObservations(ObservationsView observations);

    _FinalStage addAllObservations(List<ObservationsView> observations);

    _FinalStage scores(List<ScoreV1> scores);

    _FinalStage addScores(ScoreV1 scores);

    _FinalStage addAllScores(List<ScoreV1> scores);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, TimestampStage, HtmlPathStage, LatencyStage, TotalCostStage, _FinalStage {
    private String id;

    private OffsetDateTime timestamp;

    private String htmlPath;

    private double latency;

    private double totalCost;

    private List<ScoreV1> scores = new ArrayList<>();

    private List<ObservationsView> observations = new ArrayList<>();

    private Optional<String> environment = Optional.empty();

    private Optional<Boolean> public_ = Optional.empty();

    private Optional<List<String>> tags = Optional.empty();

    private Optional<Object> metadata = Optional.empty();

    private Optional<String> userId = Optional.empty();

    private Optional<String> version = Optional.empty();

    private Optional<String> release = Optional.empty();

    private Optional<String> sessionId = Optional.empty();

    private Optional<Object> output = Optional.empty();

    private Optional<Object> input = Optional.empty();

    private Optional<String> name = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(TraceWithFullDetails other) {
      id(other.getId());
      timestamp(other.getTimestamp());
      name(other.getName());
      input(other.getInput());
      output(other.getOutput());
      sessionId(other.getSessionId());
      release(other.getRelease());
      version(other.getVersion());
      userId(other.getUserId());
      metadata(other.getMetadata());
      tags(other.getTags());
      public_(other.getPublic());
      environment(other.getEnvironment());
      htmlPath(other.getHtmlPath());
      latency(other.getLatency());
      totalCost(other.getTotalCost());
      observations(other.getObservations());
      scores(other.getScores());
      return this;
    }

    /**
     * <p>The unique identifier of a trace</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("id")
    public TimestampStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    /**
     * <p>The timestamp when the trace was created</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("timestamp")
    public HtmlPathStage timestamp(@NotNull OffsetDateTime timestamp) {
      this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
      return this;
    }

    /**
     * <p>Path of trace in Langfuse UI</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("htmlPath")
    public LatencyStage htmlPath(@NotNull String htmlPath) {
      this.htmlPath = Objects.requireNonNull(htmlPath, "htmlPath must not be null");
      return this;
    }

    /**
     * <p>Latency of trace in seconds</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("latency")
    public TotalCostStage latency(double latency) {
      this.latency = latency;
      return this;
    }

    /**
     * <p>Cost of trace in USD</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("totalCost")
    public _FinalStage totalCost(double totalCost) {
      this.totalCost = totalCost;
      return this;
    }

    /**
     * <p>List of scores</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage addAllScores(List<ScoreV1> scores) {
      this.scores.addAll(scores);
      return this;
    }

    /**
     * <p>List of scores</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage addScores(ScoreV1 scores) {
      this.scores.add(scores);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "scores",
        nulls = Nulls.SKIP
    )
    public _FinalStage scores(List<ScoreV1> scores) {
      this.scores.clear();
      this.scores.addAll(scores);
      return this;
    }

    /**
     * <p>List of observations</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage addAllObservations(List<ObservationsView> observations) {
      this.observations.addAll(observations);
      return this;
    }

    /**
     * <p>List of observations</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage addObservations(ObservationsView observations) {
      this.observations.add(observations);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "observations",
        nulls = Nulls.SKIP
    )
    public _FinalStage observations(List<ObservationsView> observations) {
      this.observations.clear();
      this.observations.addAll(observations);
      return this;
    }

    /**
     * <p>The environment from which this trace originated. Can be any lowercase alphanumeric string with hyphens and underscores that does not start with 'langfuse'.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage environment(String environment) {
      this.environment = Optional.ofNullable(environment);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "environment",
        nulls = Nulls.SKIP
    )
    public _FinalStage environment(Optional<String> environment) {
      this.environment = environment;
      return this;
    }

    /**
     * <p>Public traces are accessible via url without login</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage public_(Boolean public_) {
      this.public_ = Optional.ofNullable(public_);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "public",
        nulls = Nulls.SKIP
    )
    public _FinalStage public_(Optional<Boolean> public_) {
      this.public_ = public_;
      return this;
    }

    /**
     * <p>The tags associated with the trace. Can be an array of strings or null.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage tags(List<String> tags) {
      this.tags = Optional.ofNullable(tags);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "tags",
        nulls = Nulls.SKIP
    )
    public _FinalStage tags(Optional<List<String>> tags) {
      this.tags = tags;
      return this;
    }

    /**
     * <p>The metadata associated with the trace. Can be any JSON.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage metadata(Object metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "metadata",
        nulls = Nulls.SKIP
    )
    public _FinalStage metadata(Optional<Object> metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * <p>The user identifier associated with the trace</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage userId(String userId) {
      this.userId = Optional.ofNullable(userId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "userId",
        nulls = Nulls.SKIP
    )
    public _FinalStage userId(Optional<String> userId) {
      this.userId = userId;
      return this;
    }

    /**
     * <p>The version of the trace</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage version(String version) {
      this.version = Optional.ofNullable(version);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "version",
        nulls = Nulls.SKIP
    )
    public _FinalStage version(Optional<String> version) {
      this.version = version;
      return this;
    }

    /**
     * <p>The release version of the application when the trace was created</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage release(String release) {
      this.release = Optional.ofNullable(release);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "release",
        nulls = Nulls.SKIP
    )
    public _FinalStage release(Optional<String> release) {
      this.release = release;
      return this;
    }

    /**
     * <p>The session identifier associated with the trace</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage sessionId(String sessionId) {
      this.sessionId = Optional.ofNullable(sessionId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "sessionId",
        nulls = Nulls.SKIP
    )
    public _FinalStage sessionId(Optional<String> sessionId) {
      this.sessionId = sessionId;
      return this;
    }

    /**
     * <p>The output data of the trace. Can be any JSON.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage output(Object output) {
      this.output = Optional.ofNullable(output);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "output",
        nulls = Nulls.SKIP
    )
    public _FinalStage output(Optional<Object> output) {
      this.output = output;
      return this;
    }

    /**
     * <p>The input data of the trace. Can be any JSON.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage input(Object input) {
      this.input = Optional.ofNullable(input);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "input",
        nulls = Nulls.SKIP
    )
    public _FinalStage input(Optional<Object> input) {
      this.input = input;
      return this;
    }

    /**
     * <p>The name of the trace</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public _FinalStage name(Optional<String> name) {
      this.name = name;
      return this;
    }

    @java.lang.Override
    public TraceWithFullDetails build() {
      return new TraceWithFullDetails(id, timestamp, name, input, output, sessionId, release, version, userId, metadata, tags, public_, environment, htmlPath, latency, totalCost, observations, scores, additionalProperties);
    }
  }
}
