/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.comments.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = CreateCommentRequest.Builder.class
)
public final class CreateCommentRequest {
  private final String projectId;

  private final String objectType;

  private final String objectId;

  private final String content;

  private final Optional<String> authorUserId;

  private final Map<String, Object> additionalProperties;

  private CreateCommentRequest(String projectId, String objectType, String objectId, String content,
      Optional<String> authorUserId, Map<String, Object> additionalProperties) {
    this.projectId = projectId;
    this.objectType = objectType;
    this.objectId = objectId;
    this.content = content;
    this.authorUserId = authorUserId;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The id of the project to attach the comment to.
   */
  @JsonProperty("projectId")
  public String getProjectId() {
    return projectId;
  }

  /**
   * @return The type of the object to attach the comment to (trace, observation, session, prompt).
   */
  @JsonProperty("objectType")
  public String getObjectType() {
    return objectType;
  }

  /**
   * @return The id of the object to attach the comment to. If this does not reference a valid existing object, an error will be thrown.
   */
  @JsonProperty("objectId")
  public String getObjectId() {
    return objectId;
  }

  /**
   * @return The content of the comment. May include markdown. Currently limited to 3000 characters.
   */
  @JsonProperty("content")
  public String getContent() {
    return content;
  }

  /**
   * @return The id of the user who created the comment.
   */
  @JsonProperty("authorUserId")
  public Optional<String> getAuthorUserId() {
    return authorUserId;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateCommentRequest && equalTo((CreateCommentRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateCommentRequest other) {
    return projectId.equals(other.projectId) && objectType.equals(other.objectType) && objectId.equals(other.objectId) && content.equals(other.content) && authorUserId.equals(other.authorUserId);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.projectId, this.objectType, this.objectId, this.content, this.authorUserId);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static ProjectIdStage builder() {
    return new Builder();
  }

  public interface ProjectIdStage {
    ObjectTypeStage projectId(@NotNull String projectId);

    Builder from(CreateCommentRequest other);
  }

  public interface ObjectTypeStage {
    ObjectIdStage objectType(@NotNull String objectType);
  }

  public interface ObjectIdStage {
    ContentStage objectId(@NotNull String objectId);
  }

  public interface ContentStage {
    _FinalStage content(@NotNull String content);
  }

  public interface _FinalStage {
    CreateCommentRequest build();

    _FinalStage authorUserId(Optional<String> authorUserId);

    _FinalStage authorUserId(String authorUserId);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements ProjectIdStage, ObjectTypeStage, ObjectIdStage, ContentStage, _FinalStage {
    private String projectId;

    private String objectType;

    private String objectId;

    private String content;

    private Optional<String> authorUserId = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateCommentRequest other) {
      projectId(other.getProjectId());
      objectType(other.getObjectType());
      objectId(other.getObjectId());
      content(other.getContent());
      authorUserId(other.getAuthorUserId());
      return this;
    }

    /**
     * <p>The id of the project to attach the comment to.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("projectId")
    public ObjectTypeStage projectId(@NotNull String projectId) {
      this.projectId = Objects.requireNonNull(projectId, "projectId must not be null");
      return this;
    }

    /**
     * <p>The type of the object to attach the comment to (trace, observation, session, prompt).</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("objectType")
    public ObjectIdStage objectType(@NotNull String objectType) {
      this.objectType = Objects.requireNonNull(objectType, "objectType must not be null");
      return this;
    }

    /**
     * <p>The id of the object to attach the comment to. If this does not reference a valid existing object, an error will be thrown.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("objectId")
    public ContentStage objectId(@NotNull String objectId) {
      this.objectId = Objects.requireNonNull(objectId, "objectId must not be null");
      return this;
    }

    /**
     * <p>The content of the comment. May include markdown. Currently limited to 3000 characters.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("content")
    public _FinalStage content(@NotNull String content) {
      this.content = Objects.requireNonNull(content, "content must not be null");
      return this;
    }

    /**
     * <p>The id of the user who created the comment.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage authorUserId(String authorUserId) {
      this.authorUserId = Optional.ofNullable(authorUserId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "authorUserId",
        nulls = Nulls.SKIP
    )
    public _FinalStage authorUserId(Optional<String> authorUserId) {
      this.authorUserId = authorUserId;
      return this;
    }

    @java.lang.Override
    public CreateCommentRequest build() {
      return new CreateCommentRequest(projectId, objectType, objectId, content, authorUserId, additionalProperties);
    }
  }
}
