/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client;

import com.langfuse.client.core.ClientOptions;
import com.langfuse.client.core.Environment;
import java.lang.String;
import java.util.Base64;
import okhttp3.OkHttpClient;

public final class LangfuseClientBuilder {
  private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();

  private String username = null;

  private String password = null;

  private String xLangfuseSdkName = null;

  private String xLangfuseSdkVersion = null;

  private String xLangfusePublicKey = null;

  private Environment environment;

  public LangfuseClientBuilder credentials(String username, String password) {
    this.username = username;
    this.password = password;
    return this;
  }

  /**
   * Sets xLangfuseSdkName
   */
  public LangfuseClientBuilder xLangfuseSdkName(String xLangfuseSdkName) {
    this.xLangfuseSdkName = xLangfuseSdkName;
    return this;
  }

  /**
   * Sets xLangfuseSdkVersion
   */
  public LangfuseClientBuilder xLangfuseSdkVersion(String xLangfuseSdkVersion) {
    this.xLangfuseSdkVersion = xLangfuseSdkVersion;
    return this;
  }

  /**
   * Sets xLangfusePublicKey
   */
  public LangfuseClientBuilder xLangfusePublicKey(String xLangfusePublicKey) {
    this.xLangfusePublicKey = xLangfusePublicKey;
    return this;
  }

  public LangfuseClientBuilder url(String url) {
    this.environment = Environment.custom(url);
    return this;
  }

  /**
   * Sets the timeout (in seconds) for the client
   */
  public LangfuseClientBuilder timeout(int timeout) {
    this.clientOptionsBuilder.timeout(timeout);
    return this;
  }

  /**
   * Sets the underlying OkHttp client
   */
  public LangfuseClientBuilder httpClient(OkHttpClient httpClient) {
    this.clientOptionsBuilder.httpClient(httpClient);
    return this;
  }

  public LangfuseClient build() {
    String unencodedToken = username + ":" + password;
    String encodedToken = Base64.getEncoder().encodeToString(unencodedToken.getBytes());
    this.clientOptionsBuilder.addHeader("Authorization", "Basic " + encodedToken);
    if (xLangfuseSdkName != null) {
      this.clientOptionsBuilder.addHeader("X-Langfuse-Sdk-Name", this.xLangfuseSdkName);
    }
    if (xLangfuseSdkVersion != null) {
      this.clientOptionsBuilder.addHeader("X-Langfuse-Sdk-Version", this.xLangfuseSdkVersion);
    }
    if (xLangfusePublicKey != null) {
      this.clientOptionsBuilder.addHeader("X-Langfuse-Public-Key", this.xLangfusePublicKey);
    }
    clientOptionsBuilder.environment(this.environment);
    return new LangfuseClient(clientOptionsBuilder.build());
  }
}
