/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.validators;

import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.ValidationError;
import com.kenshoo.pl.entity.spi.ChangesValidator;
import java.util.Collection;
import java.util.Map;

public class RequiredAtLeastOneChildValidator<E extends EntityType<E>, CHILD extends EntityType<CHILD>>
implements ChangesValidator<E> {
    private final String errorCode;
    private final CHILD childType;

    public RequiredAtLeastOneChildValidator(CHILD childType, String errorCode) {
        this.errorCode = errorCode;
        this.childType = childType;
    }

    @Override
    public void validate(Collection<? extends EntityChange<E>> entityChanges, ChangeOperation changeOperation, ChangeContext changeContext) {
        entityChanges.forEach(entityChange -> {
            long childrenAmount = entityChange.getChildren(this.childType).count();
            if (childrenAmount == 0L) {
                changeContext.addValidationError((EntityChange<? extends EntityType<?>>)entityChange, new ValidationError(this.errorCode, Map.of("childType", this.childType.getName())));
            }
        });
    }

    @Override
    public SupportedChangeOperation getSupportedChangeOperation() {
        return SupportedChangeOperation.CREATE;
    }
}

