/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.spi.helpers;

import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.PLCondition;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.UniqueKey;
import com.kenshoo.pl.entity.ValidationError;
import com.kenshoo.pl.entity.internal.EntitiesFetcher;
import com.kenshoo.pl.entity.internal.EntityWithNullForMissingField;
import com.kenshoo.pl.entity.spi.ChangesValidator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.jooq.lambda.Seq;

public class UniquenessValidator<E extends EntityType<E>>
implements ChangesValidator<E> {
    private final String errorCode;
    private final EntitiesFetcher fetcher;
    private final UniqueKey<E> uniqueKey;
    private final PLCondition condition;
    private final SupportedChangeOperation operation;

    private UniquenessValidator(EntitiesFetcher fetcher, UniqueKey<E> uniqueKey, SupportedChangeOperation operation, PLCondition condition, String errorCode) {
        this.errorCode = errorCode;
        this.fetcher = Objects.requireNonNull(fetcher, "entity fetcher must be provided");
        this.uniqueKey = Objects.requireNonNull(uniqueKey, "unique key must be provided");
        this.condition = Objects.requireNonNull(condition, "condition must be provided");
        this.operation = Objects.requireNonNull(operation, "operation must be provided");
    }

    @Override
    public SupportedChangeOperation getSupportedChangeOperation() {
        return this.operation;
    }

    @Override
    public void validate(Collection<? extends EntityChange<E>> commands, ChangeOperation op, ChangeContext ctx) {
        List commandsToValidate = commands.stream().filter(this.hasChangeInUniqueKeyField()).collect(Collectors.toList());
        Map<Identifier<E>, EntityChange<E>> commandsByIds = this.markDuplicatesInCollectionWithErrors(commandsToValidate, ctx);
        if (commandsByIds.isEmpty()) {
            return;
        }
        UniqueKey pk = this.uniqueKey.getEntityType().getPrimaryKey();
        EntityField[] uniqueKeyAndPK = (EntityField[])ArrayUtils.addAll((Object[])this.uniqueKey.getFields(), (Object[])pk.getFields());
        Map duplicates = this.fetcher.fetch((EntityType<?>)this.uniqueKey.getEntityType(), (Collection<? extends Identifier<?>>)commandsByIds.keySet(), this.condition, (EntityField<?, ?>[])uniqueKeyAndPK).stream().collect(Collectors.toMap(e -> this.createKeyValue((CurrentEntityState)e, this.uniqueKey), Function.identity(), (a, b) -> a));
        duplicates.forEach((dupKey, dupEntity) -> ctx.addValidationError((EntityChange)commandsByIds.get(dupKey), this.errorForDatabaseConflict((CurrentEntityState)dupEntity, pk)));
    }

    private Predicate<EntityChange<E>> hasChangeInUniqueKeyField() {
        return cmd -> {
            if (!ChangeOperation.UPDATE.equals((Object)cmd.getChangeOperation())) return true;
            if (!Arrays.stream(this.uniqueKey.getFields()).anyMatch(cmd::isFieldChanged)) return false;
            return true;
        };
    }

    private Map<Identifier<E>, EntityChange<E>> markDuplicatesInCollectionWithErrors(Collection<? extends EntityChange<E>> commands, ChangeContext ctx) {
        return commands.stream().filter(command -> this.condition.getPostFetchCondition().test(ctx.getFinalEntity((EntityChange<? extends EntityType<?>>)command))).collect(Collectors.toMap(cmd -> UniquenessValidator.createKeyValue(cmd, ctx, this.uniqueKey), Function.identity(), this.fail2ndConflictingCommand(ctx)));
    }

    private ValidationError errorForDatabaseConflict(CurrentEntityState dupEntity, UniqueKey<E> pk) {
        return new ValidationError(this.errorCode, Seq.of((Object[])pk.getFields()).toMap(Object::toString, field -> String.valueOf(dupEntity.get(field))));
    }

    private BinaryOperator<EntityChange<E>> fail2ndConflictingCommand(ChangeContext ctx) {
        return (cmd1, cmd2) -> {
            ctx.addValidationError((EntityChange<? extends EntityType<?>>)cmd2, new ValidationError(this.errorCode));
            return cmd1;
        };
    }

    private static <E extends EntityType<E>> Identifier<E> createKeyValue(EntityChange<E> cmd, ChangeContext ctx, UniqueKey<E> key) {
        return key.createIdentifier(new EntityWithNullForMissingField(ctx.getFinalEntity(cmd)));
    }

    private Identifier<E> createKeyValue(CurrentEntityState currentEntityState, UniqueKey<E> key) {
        return key.createIdentifier(currentEntityState);
    }

    @Override
    public Stream<? extends EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToUpdate, ChangeOperation op) {
        return Seq.concat((Stream[])new Stream[]{this.condition.getFields().stream(), Stream.of(this.uniqueKey.getFields()), Stream.of(this.uniqueKey.getEntityType().getPrimaryKey().getFields())});
    }

    public static class Builder<E extends EntityType<E>> {
        private String errorCode = "DUPLICATE_ENTITY";
        private final EntitiesFetcher fetcher;
        private final UniqueKey<E> uniqueKey;
        private PLCondition condition = PLCondition.trueCondition();
        private SupportedChangeOperation operation = SupportedChangeOperation.CREATE;

        public Builder(EntitiesFetcher fetcher, UniqueKey<E> uniqueKey) {
            this.fetcher = fetcher;
            this.uniqueKey = uniqueKey;
        }

        public Builder<E> setOperation(SupportedChangeOperation operation) {
            this.operation = operation;
            return this;
        }

        public Builder<E> setCondition(PLCondition condition) {
            this.condition = condition;
            return this;
        }

        public Builder<E> setErrorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public UniquenessValidator<E> build() {
            return new UniquenessValidator<E>(this.fetcher, this.uniqueKey, this.operation, this.condition, this.errorCode);
        }
    }
}

