/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.mysql;

import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.kenshoo.pl.entity.spi.DeadlockDetector;
import java.sql.SQLException;
import org.jooq.lambda.Seq;

public class MySqlDeadlockDetector
implements DeadlockDetector {
    private String retryPatterns = "lock wait timeout exceeded;deadlock";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDeadlock(Throwable e) {
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        if (!(rootCause instanceof SQLException)) return false;
        if (rootCause.getMessage() == null) return false;
        if (!this.deadlockStrings().anyMatch(rootCause.getMessage().toLowerCase()::contains)) return false;
        return true;
    }

    private Seq<String> deadlockStrings() {
        return Seq.seq((Iterable)Splitter.on((String)";").trimResults().omitEmptyStrings().splitToList((CharSequence)this.retryPatterns));
    }
}

