/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.validators;

import com.google.common.collect.Collections2;
import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.internal.ChangesFilter;
import com.kenshoo.pl.entity.spi.ChangesValidator;
import com.kenshoo.pl.entity.spi.CurrentStateConsumer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public class ValidationFilter<E extends EntityType<E>>
implements ChangesFilter<E> {
    private final List<ChangesValidator<E>> validators;

    public ValidationFilter(List<ChangesValidator<E>> validators) {
        this.validators = validators;
    }

    @Override
    public <T extends EntityChange<E>> Collection<T> filter(Collection<T> commands, ChangeOperation changeOperation, ChangeContext changeContext) {
        this.validators.stream().filter(CurrentStateConsumer.supporting(changeOperation)).forEach(validator -> validator.validate(commands, changeOperation, changeContext));
        return Collections2.filter(commands, entityChange -> !changeContext.containsErrorNonRecursive((EntityChange)entityChange));
    }

    @Override
    public Stream<? extends EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToUpdate, ChangeOperation changeOperation) {
        return this.validators.stream().filter(CurrentStateConsumer.supporting(changeOperation)).flatMap(changesValidator -> changesValidator.requiredFields(fieldsToUpdate, changeOperation));
    }

    @Override
    public SupportedChangeOperation getSupportedChangeOperation() {
        return SupportedChangeOperation.CREATE_UPDATE_AND_DELETE;
    }
}

