/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.google.common.annotations.VisibleForTesting;
import com.kenshoo.pl.entity.FieldValue;
import com.kenshoo.pl.entity.FinalEntityState;
import com.kenshoo.pl.entity.Triptional;
import com.kenshoo.pl.entity.internal.audit.AuditFieldValueResolver;
import com.kenshoo.pl.entity.internal.audit.AuditedField;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jooq.lambda.Seq;

public class AuditMandatoryFieldValuesGenerator {
    private final Collection<AuditedField<?, ?>> mandatoryFields;
    private final AuditFieldValueResolver auditFieldValueResolver;

    public AuditMandatoryFieldValuesGenerator(Stream<? extends AuditedField<?, ?>> mandatoryFields) {
        this(mandatoryFields, AuditFieldValueResolver.INSTANCE);
    }

    @VisibleForTesting
    AuditMandatoryFieldValuesGenerator(Stream<? extends AuditedField<?, ?>> mandatoryFields, AuditFieldValueResolver auditFieldValueResolver) {
        Objects.requireNonNull(mandatoryFields, "mandatoryFields must not be null (can be empty)");
        this.mandatoryFields = mandatoryFields.collect(Collectors.toList());
        this.auditFieldValueResolver = auditFieldValueResolver;
    }

    Collection<FieldValue> generate(FinalEntityState finalState) {
        Objects.requireNonNull(finalState, "finalState is required");
        return (Collection)Seq.seq(this.mandatoryFields).map(field -> ImmutablePair.of((Object)field, this.auditFieldValueResolver.resolveToString(field, finalState))).filter(pair -> ((Triptional)pair.getValue()).isNotNull()).map(pair -> new FieldValue(((AuditedField)pair.getKey()).getName(), (String)((Triptional)pair.getValue()).get())).collect(Collectors.toList());
    }
}

