/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.google.common.annotations.VisibleForTesting;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.annotation.audit.Audited;
import com.kenshoo.pl.entity.internal.EntityTypeReflectionUtil;
import com.kenshoo.pl.entity.spi.audit.AuditFieldValueFormatter;
import com.kenshoo.pl.entity.spi.audit.DefaultAuditFieldValueFormatter;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditFieldValueFormatterResolver {
    private static final Logger logger = LoggerFactory.getLogger(AuditFieldValueFormatterResolver.class);
    static final AuditFieldValueFormatterResolver INSTANCE = new AuditFieldValueFormatterResolver();
    private final AuditFieldValueFormatter defaultFormatter;

    private AuditFieldValueFormatterResolver() {
        this(DefaultAuditFieldValueFormatter.INSTANCE);
    }

    @VisibleForTesting
    AuditFieldValueFormatterResolver(AuditFieldValueFormatter defaultFormatter) {
        this.defaultFormatter = defaultFormatter;
    }

    public <E extends EntityType<E>> AuditFieldValueFormatter resolve(EntityField<E, ?> field) {
        Objects.requireNonNull(field, "field is required");
        return Stream.of(() -> this.extractFieldLevelFormatter(field), () -> this.extractEntityLevelFormatter(field.getEntityType())).map(Supplier::get).flatMap(Optional::stream).findFirst().orElse(this.defaultFormatter);
    }

    private <E extends EntityType<E>> Optional<AuditFieldValueFormatter> extractFieldLevelFormatter(EntityField<E, ?> field) {
        return Optional.ofNullable(EntityTypeReflectionUtil.getFieldAnnotation(field.getEntityType(), field, Audited.class)).flatMap(this::extractFormatter);
    }

    private Optional<AuditFieldValueFormatter> extractEntityLevelFormatter(EntityType<?> entityType) {
        return Optional.ofNullable(entityType.getClass().getAnnotation(Audited.class)).flatMap(this::extractFormatter);
    }

    private Optional<AuditFieldValueFormatter> extractFormatter(Audited auditedAnnotation) {
        return Optional.of(auditedAnnotation.valueFormatter()).filter(Predicate.not(AuditFieldValueFormatter.MissingAuditFieldValueFormatter.class::equals)).flatMap(this::createFormatter);
    }

    private Optional<? extends AuditFieldValueFormatter> createFormatter(Class<? extends AuditFieldValueFormatter> formatterClass) {
        try {
            return Optional.of(formatterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Failed to create a formatter of type {} - either it doesn't have a no-arg constructor, or the constructor is not public. Falling back to the default formatter.", formatterClass, (Object)e);
            return Optional.empty();
        }
    }
}

