/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.annotation.audit.Audited;
import com.kenshoo.pl.entity.internal.EntityTypeReflectionUtil;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AuditFieldNameResolver {
    static final AuditFieldNameResolver INSTANCE = new AuditFieldNameResolver();

    public <E extends EntityType<E>> String resolve(EntityField<E, ?> field) {
        Objects.requireNonNull(field, "field is required");
        return Optional.ofNullable(EntityTypeReflectionUtil.getFieldAnnotation(field.getEntityType(), field, Audited.class)).map(Audited::name).filter(StringUtils::isNotBlank).orElse(field.toString());
    }

    private AuditFieldNameResolver() {
    }
}

