/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.google.common.collect.Collections2;
import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.ValidationError;
import com.kenshoo.pl.entity.internal.ChangesFilter;
import java.util.Collection;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public class MissingParentEntitiesFilter<E extends EntityType<E>>
implements ChangesFilter<E> {
    private final Collection<EntityField<E, ?>> foreignKeys;

    public MissingParentEntitiesFilter(Collection<EntityField<E, ?>> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    @Override
    public <T extends EntityChange<E>> Collection<T> filter(Collection<T> changes, ChangeOperation changeOperation, ChangeContext changeContext) {
        if (this.foreignKeys.isEmpty()) {
            return changes;
        }
        return Collections2.filter(changes, command -> {
            CurrentEntityState currentState = changeContext.getEntity((EntityChange)command);
            if (currentState == CurrentEntityState.EMPTY) {
                changeContext.addValidationError((EntityChange<? extends EntityType<?>>)command, new ValidationError("persistence.parent_entity_not_found", Seq.seq(this.foreignKeys).toMap(Object::toString, f -> command.safeGet(f).toString())));
                return false;
            }
            return true;
        });
    }

    @Override
    public Stream<? extends EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToUpdate, ChangeOperation changeOperation) {
        return Stream.of(new EntityField[0]);
    }

    @Override
    public SupportedChangeOperation getSupportedChangeOperation() {
        return SupportedChangeOperation.CREATE;
    }
}

