/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityFieldDbAdapter;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.ValueConverter;
import com.kenshoo.pl.entity.equalityfunctions.EntityValueEqualityFunction;

public class EntityFieldImpl<E extends EntityType<E>, T>
implements EntityField<E, T> {
    private final EntityType<E> entityType;
    private final EntityFieldDbAdapter<T> dbAdapter;
    private final EntityValueEqualityFunction<T> valueEqualityFunction;
    private final ValueConverter<T, String> stringValueConverter;

    public EntityFieldImpl(EntityType<E> entityType, EntityFieldDbAdapter<T> dbAdapter, ValueConverter<T, String> stringValueConverter, EntityValueEqualityFunction<T> valueEqualityFunction) {
        this.entityType = entityType;
        this.dbAdapter = dbAdapter;
        this.stringValueConverter = stringValueConverter;
        this.valueEqualityFunction = valueEqualityFunction;
    }

    @Override
    public EntityFieldDbAdapter<T> getDbAdapter() {
        return this.dbAdapter;
    }

    @Override
    public ValueConverter<T, String> getStringValueConverter() {
        return this.stringValueConverter;
    }

    @Override
    public boolean valuesEqual(T v1, T v2) {
        return (Boolean)this.valueEqualityFunction.apply(v1, v2);
    }

    @Override
    public EntityType<E> getEntityType() {
        return this.entityType;
    }

    public String toString() {
        return this.entityType.toFieldName(this);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }
}

