/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.audit;

import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.spi.audit.AuditFieldValueFormatter;
import com.kenshoo.pl.entity.spi.audit.DefaultAuditFieldValueFormatter;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ExternalAuditedField<E extends EntityType<E>, T> {
    private final EntityField<E, T> field;
    private final String name;
    private final AuditFieldValueFormatter valueFormatter;

    @Deprecated
    public ExternalAuditedField(EntityField<E, T> field) {
        this(Objects.requireNonNull(field, "An underlying field must be provided"), field.toString());
    }

    @Deprecated
    public ExternalAuditedField(EntityField<E, T> field, String name) {
        this(field, name, DefaultAuditFieldValueFormatter.INSTANCE);
    }

    private ExternalAuditedField(EntityField<E, T> field, String name, AuditFieldValueFormatter valueFormatter) {
        this.field = Objects.requireNonNull(field, "An underlying field must be provided");
        this.name = Objects.requireNonNull(name, "A name must be provided");
        this.valueFormatter = valueFormatter;
    }

    public EntityField<E, T> getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public Optional<AuditFieldValueFormatter> getValueFormatter() {
        return Optional.ofNullable(this.valueFormatter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalAuditedField that = (ExternalAuditedField)o;
        return new EqualsBuilder().append(this.field, that.field).append((Object)this.name, (Object)that.name).append((Object)this.valueFormatter, (Object)that.valueFormatter).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.field).append((Object)this.name).append((Object)this.valueFormatter).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("field", this.field).append("name", (Object)this.name).append("valueFormatter", (Object)this.valueFormatter).toString();
    }

    public static class Builder<E extends EntityType<E>, T> {
        private final EntityField<E, T> field;
        private String name;
        private AuditFieldValueFormatter valueFormatter;

        public Builder(EntityField<E, T> field) {
            this.field = Objects.requireNonNull(field, "An underlying field must be provided");
            this.name = field.toString();
        }

        public Builder<E, T> withName(String name) {
            this.name = name;
            return this;
        }

        public Builder<E, T> withValueFormatter(AuditFieldValueFormatter valueFormatter) {
            this.valueFormatter = valueFormatter;
            return this;
        }

        public ExternalAuditedField<E, T> build() {
            return new ExternalAuditedField<E, T>(this.field, this.name, this.valueFormatter);
        }
    }
}

