/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.audit;

import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.FieldValue;
import com.kenshoo.pl.entity.audit.FieldAuditRecord;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AuditRecord {
    private final String entityType;
    private final String entityId;
    private final Collection<? extends FieldValue> mandatoryFieldValues;
    private final ChangeOperation operator;
    private final String entityChangeDescription;
    private final Collection<? extends FieldAuditRecord> fieldRecords;
    private final Collection<? extends AuditRecord> childRecords;

    private AuditRecord(String entityType, String entityId, Collection<? extends FieldValue> mandatoryFieldValues, ChangeOperation operator, String entityChangeDescription, Collection<? extends FieldAuditRecord> fieldRecords, Collection<? extends AuditRecord> childRecords) {
        this.entityType = Objects.requireNonNull(entityType, "entityType is required");
        this.entityId = entityId;
        this.mandatoryFieldValues = mandatoryFieldValues;
        this.operator = Objects.requireNonNull(operator, "operator is required");
        this.entityChangeDescription = entityChangeDescription;
        this.fieldRecords = fieldRecords;
        this.childRecords = childRecords;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Optional<String> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    public Collection<? extends FieldValue> getMandatoryFieldValues() {
        return this.mandatoryFieldValues;
    }

    public ChangeOperation getOperator() {
        return this.operator;
    }

    public Optional<String> getEntityChangeDescription() {
        return Optional.ofNullable(this.entityChangeDescription);
    }

    public Collection<? extends FieldAuditRecord> getFieldRecords() {
        return this.fieldRecords;
    }

    public Collection<? extends AuditRecord> getChildRecords() {
        return this.childRecords;
    }

    public boolean hasNoChanges() {
        return this.fieldRecords.isEmpty() && this.childRecords.isEmpty();
    }

    public String toString() {
        return this.toString(Integer.MAX_VALUE);
    }

    public String toString(int maxDepth) {
        if (maxDepth <= 0) {
            return "";
        }
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("entityType", (Object)this.entityType).append("entityId", (Object)this.entityId).append("mandatoryFieldValues", this.mandatoryFieldValues).append("operator", (Object)this.operator).append("entityChangeDescription", (Object)this.entityChangeDescription).append("fieldRecords", this.fieldRecords).append("childRecords", (Object)this.childRecordsToString(maxDepth)).toString();
    }

    private String childRecordsToString(int maxDepth) {
        return this.childRecords.stream().map(childRecord -> childRecord.toString(maxDepth - 1)).collect(Collectors.toList()).toString();
    }

    public static class Builder {
        private String entityType;
        private String entityId;
        private Collection<? extends FieldValue> mandatoryFieldValues = Collections.emptyList();
        private ChangeOperation operator;
        private String entityChangeDescription;
        private Collection<? extends FieldAuditRecord> fieldRecords = Collections.emptyList();
        private Collection<? extends AuditRecord> childRecords = Collections.emptyList();

        public Builder withEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder withEntityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder withOperator(ChangeOperation operator) {
            this.operator = operator;
            return this;
        }

        public Builder withEntityChangeDescription(String entityChangeDescription) {
            this.entityChangeDescription = entityChangeDescription;
            return this;
        }

        public Builder withMandatoryFieldValues(Collection<? extends FieldValue> fieldValues) {
            this.mandatoryFieldValues = fieldValues == null ? Collections.emptyList() : fieldValues;
            return this;
        }

        public Builder withFieldRecords(Collection<? extends FieldAuditRecord> fieldRecords) {
            this.fieldRecords = fieldRecords == null ? Collections.emptyList() : fieldRecords;
            return this;
        }

        public Builder withChildRecords(Collection<? extends AuditRecord> childRecords) {
            this.childRecords = childRecords == null ? Collections.emptyList() : childRecords;
            return this;
        }

        public AuditRecord build() {
            return new AuditRecord(this.entityType, this.entityId, this.mandatoryFieldValues, this.operator, this.entityChangeDescription, this.fieldRecords, this.childRecords);
        }
    }
}

