/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.UniqueKey;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;

public class UniqueKeyValue<E extends EntityType<E>>
implements Identifier<E> {
    private final UniqueKey<E> uniqueKey;
    protected final Object[] values;
    private int hashCode;

    protected UniqueKeyValue(UniqueKey<E> uniqueKey, Object[] values) {
        this.uniqueKey = uniqueKey;
        this.values = values;
    }

    public static <E extends EntityType<E>> UniqueKeyValue<E> empty() {
        return new UniqueKeyValue(new UniqueKey(new EntityField[0]), new Object[0]);
    }

    @Override
    public <T> boolean containsField(EntityField<E, T> field) {
        return Stream.of(this.uniqueKey.getFields()).filter(field::equals).findFirst().isPresent();
    }

    @Override
    public <T> T get(EntityField<E, T> field) {
        EntityField<E, ?>[] keyFields = this.uniqueKey.getFields();
        int index = 0;
        for (EntityField<E, ?> keyField : keyFields) {
            if (keyField.equals(field)) {
                return (T)this.values[index];
            }
            ++index;
        }
        throw new IllegalArgumentException("Field " + field + " is not a key field");
    }

    @Override
    public UniqueKey<E> getUniqueKey() {
        return this.uniqueKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniqueKeyValue)) {
            return false;
        }
        UniqueKeyValue that = (UniqueKeyValue)o;
        if (!this.uniqueKey.equals(that.uniqueKey)) {
            return false;
        }
        return Arrays.deepEquals(this.values, that.values);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.uniqueKey.hashCode();
            this.hashCode = result = 31 * result + Arrays.deepHashCode(this.values);
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        EntityField<E, ?>[] fields = this.uniqueKey.getFields();
        String separator = "";
        int i = 0;
        for (EntityField<E, ?> field : fields) {
            stringBuilder.append(separator).append(field).append("=").append(this.values[i]);
            separator = ",";
            ++i;
        }
        return stringBuilder.append("}").toString();
    }

    public static <E extends EntityType<E>> Identifier<E> concat(Identifier<E> id1, Identifier<E> id2) {
        if (id1 == null) {
            return id2;
        }
        if (id2 == null) {
            return id1;
        }
        Seq pairs1 = Seq.of((Object[])id1.getUniqueKey().getFields()).zip(id1.getValues());
        Seq pairs2 = Seq.of((Object[])id2.getUniqueKey().getFields()).zip(id2.getValues());
        Tuple2 merged = Seq.unzip((Seq)pairs1.concat(pairs2).distinct(pair -> (EntityField)pair.v1));
        return new UniqueKeyValue(new UniqueKey((Iterable)merged.v1), ((Seq)merged.v2).toArray());
    }
}

