/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.pl.data.AffectedRows;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PersistentLayerStats {
    private final Map<String, AffectedRows> tableStats = new HashMap<String, AffectedRows>();
    private long fetchTimeMillis = 0L;
    private long updateTimeMillis = 0L;
    private long auditLogTimeMillis = 0L;

    public void addAffectedRows(String tableName, AffectedRows affectedRows) {
        this.tableStats.put(tableName, this.tableStats.getOrDefault(tableName, AffectedRows.empty()).plus(affectedRows));
    }

    public void addFetchTime(long elapsed) {
        this.fetchTimeMillis += elapsed;
    }

    public void addUpdateTime(long elapsed) {
        this.updateTimeMillis += elapsed;
    }

    public void addAuditLogTime(long elapsed) {
        this.auditLogTimeMillis += elapsed;
    }

    public PersistentLayerStats combine(PersistentLayerStats other) {
        PersistentLayerStats result = new PersistentLayerStats();
        Set allTables = Stream.concat(this.getTablesAffected().stream(), other.getTablesAffected().stream()).collect(Collectors.toSet());
        for (String table : allTables) {
            result.addAffectedRows(table, this.getAffectedRowsOf(table).plus(other.getAffectedRowsOf(table)));
        }
        result.addFetchTime(this.getFetchTime(TimeUnit.MILLISECONDS) + other.getFetchTime(TimeUnit.MILLISECONDS));
        result.addUpdateTime(this.getUpdateTime(TimeUnit.MILLISECONDS) + other.getUpdateTime(TimeUnit.MILLISECONDS));
        return result;
    }

    public Collection<String> getTablesAffected() {
        return this.tableStats.keySet();
    }

    public AffectedRows getAffectedRowsOf(String tableName) {
        return this.tableStats.getOrDefault(tableName, AffectedRows.empty());
    }

    public long getFetchTime(TimeUnit timeUnit) {
        return TimeUnit.MILLISECONDS.convert(this.fetchTimeMillis, timeUnit);
    }

    public long getUpdateTime(TimeUnit timeUnit) {
        return TimeUnit.MILLISECONDS.convert(this.updateTimeMillis, timeUnit);
    }

    public long getAuditLogTime(TimeUnit timeUnit) {
        return TimeUnit.MILLISECONDS.convert(this.auditLogTimeMillis, timeUnit);
    }
}

