/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Feature;
import com.kenshoo.pl.entity.FieldFetchRequest;
import com.kenshoo.pl.entity.Hierarchy;
import com.kenshoo.pl.entity.PersistentLayerStats;
import com.kenshoo.pl.entity.ValidationError;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import org.jooq.lambda.Seq;

public class OverridingContext
implements ChangeContext {
    private final ChangeContext original;
    private final Map<EntityChange, CurrentEntityState> overrides = new IdentityHashMap<EntityChange, CurrentEntityState>();

    public OverridingContext(ChangeContext original) {
        this.original = original;
    }

    @Override
    public boolean isEnabled(Feature feature) {
        return this.original.isEnabled(feature);
    }

    @Override
    public CurrentEntityState getEntity(EntityChange entityChange) {
        return Optional.ofNullable(this.overrides.get(entityChange)).orElseGet(() -> this.original.getEntity(entityChange));
    }

    @Override
    public void addEntity(EntityChange change, CurrentEntityState currentState) {
        this.overrides.put(change, new OverridingEntity(currentState, this.original.getEntity(change)));
    }

    @Override
    public void addValidationError(EntityChange<? extends EntityType<?>> entityChange, ValidationError error) {
        this.original.addValidationError(entityChange, error);
    }

    @Override
    public boolean hasValidationErrors() {
        return this.original.hasValidationErrors();
    }

    @Override
    public Seq<ValidationError> getValidationErrors(EntityChange cmd) {
        return this.original.getValidationErrors(cmd);
    }

    @Override
    public boolean containsError(EntityChange entityChange) {
        return this.original.containsError(entityChange);
    }

    @Override
    public boolean containsErrorNonRecursive(EntityChange entityChange) {
        return this.original.containsErrorNonRecursive(entityChange);
    }

    @Override
    public PersistentLayerStats getStats() {
        return this.original.getStats();
    }

    @Override
    public Collection<FieldFetchRequest> getFetchRequests() {
        return this.original.getFetchRequests();
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.original.getHierarchy();
    }

    private static class OverridingEntity
    implements CurrentEntityState {
        private final CurrentEntityState overriding;
        private final CurrentEntityState original;

        private OverridingEntity(CurrentEntityState overriding, CurrentEntityState original) {
            this.overriding = overriding;
            this.original = original;
        }

        @Override
        public boolean containsField(EntityField<?, ?> field) {
            return this.overriding.containsField(field) || this.original.containsField(field);
        }

        @Override
        public <T> T get(EntityField<?, T> field) {
            return this.overriding.containsField(field) ? this.overriding.get(field) : this.original.get(field);
        }
    }
}

