/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.jooq.FieldAndValues;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityFieldDbAdapter;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FieldsValueMap;
import com.kenshoo.pl.entity.IdentifierType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public interface Identifier<E extends EntityType<E>>
extends FieldsValueMap<E> {
    public IdentifierType<E> getUniqueKey();

    default public Stream<Object> getValues() {
        return Seq.of((Object[])this.getUniqueKey().getFields()).map(this::get);
    }

    default public boolean isEmpty() {
        return !this.getValues().findAny().isPresent();
    }

    default public int size() {
        return this.getUniqueKey().getFields().length;
    }

    default public boolean contains(Identifier<E> otherIdentifier) {
        return Arrays.asList(this.getUniqueKey().getFields()).containsAll(Arrays.asList(otherIdentifier.getUniqueKey().getFields()));
    }

    public static <E extends EntityType<E>> List<FieldAndValues<?>> groupValuesByFields(Collection<? extends Identifier<E>> ids) {
        IdentifierType<E> uniqueKey = ids.iterator().next().getUniqueKey();
        return Stream.of(uniqueKey.getFields()).map(field -> Identifier.collectValuesOf(field, ids)).collect(Collectors.toList());
    }

    public static <E extends EntityType<E>, T> FieldAndValues<?> collectValuesOf(EntityField<E, T> field, Collection<? extends Identifier<E>> ids) {
        EntityFieldDbAdapter dbAdapter = field.getDbAdapter();
        List fieldValues = ids.stream().flatMap(id -> (Stream)dbAdapter.getDbValues(id.get(field)).sequential()).collect(Collectors.toList());
        return new FieldAndValues(dbAdapter.getFirstTableField(), fieldValues);
    }
}

