/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.kenshoo.pl.entity.spi.DeadlockDetector;
import com.kenshoo.pl.entity.spi.PersistenceLayerRetryer;
import com.kenshoo.pl.entity.spi.ThrowingAction;
import com.kenshoo.pl.entity.spi.TransactionDetector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadlockRetryer
implements PersistenceLayerRetryer {
    private static final Logger logger = LoggerFactory.getLogger(DeadlockRetryer.class);
    private int maxDeadlockRetries = 5;
    private long firstSleepBetweenRetriesMillis = 1000L;
    private long incrementSleepBetweenRetriesMillis = 0L;
    private final DeadlockDetector deadlockDetector;
    private final TransactionDetector transactionDetector;

    public DeadlockRetryer(DeadlockDetector deadlockDetector, TransactionDetector transactionDetector) {
        this.deadlockDetector = deadlockDetector;
        this.transactionDetector = transactionDetector;
    }

    @Override
    public void run(ThrowingAction action) {
        try {
            this.deadlockRetryer().call(() -> {
                action.run();
                return null;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("DatabaseDeadlockRetryer: Failed to execute deadlock retryer", e);
        }
        catch (RetryException e) {
            throw new RuntimeException("DatabaseDeadlockRetryer: Retry failure, number of attempts " + e.getNumberOfFailedAttempts(), e);
        }
    }

    private Retryer<Void> deadlockRetryer() {
        return RetryerBuilder.newBuilder().retryIfException(e -> this.deadlockDetector.isDeadlock((Throwable)e) && !this.transactionDetector.isActiveTransactionExist()).withStopStrategy(StopStrategies.stopAfterAttempt((int)this.maxDeadlockRetries)).withWaitStrategy(WaitStrategies.incrementingWait((long)this.firstSleepBetweenRetriesMillis, (TimeUnit)TimeUnit.MILLISECONDS, (long)this.incrementSleepBetweenRetriesMillis, (TimeUnit)TimeUnit.MILLISECONDS)).withRetryListener(new RetryListener(){

            public <V> void onRetry(Attempt<V> attempt) {
                long attemptNumber = attempt.getAttemptNumber();
                if (attemptNumber > 1L) {
                    logger.warn("DatabaseDeadlockRetryer: got deadlock when saving to database. This was try {} out of {}", (Object)attemptNumber, (Object)DeadlockRetryer.this.maxDeadlockRetries);
                    logger.warn("DatabaseDeadlockRetryer: delaySinceFirstAttempt: {}", (Object)attempt.getDelaySinceFirstAttempt());
                    if (attemptNumber >= (long)DeadlockRetryer.this.maxDeadlockRetries) {
                        logger.error("DatabaseDeadlockRetryer: Unsuccessfully retried deadlocked transaction {} times with first sleep of {} milliseconds and increment multiplier of {} milliseconds", new Object[]{DeadlockRetryer.this.maxDeadlockRetries, DeadlockRetryer.this.firstSleepBetweenRetriesMillis, DeadlockRetryer.this.incrementSleepBetweenRetriesMillis});
                    }
                }
            }
        }).build();
    }

    public DeadlockRetryer setMaxDeadlockRetries(int maxDeadlockRetries) {
        this.maxDeadlockRetries = maxDeadlockRetries;
        return this;
    }

    public DeadlockRetryer setFirstSleepBetweenRetriesMillis(long firstSleepBetweenRetriesMillis) {
        this.firstSleepBetweenRetriesMillis = firstSleepBetweenRetriesMillis;
        return this;
    }

    public DeadlockRetryer setIncrementSleepBetweenRetriesMillis(long incrementSleepBetweenRetriesMillis) {
        this.incrementSleepBetweenRetriesMillis = incrementSleepBetweenRetriesMillis;
        return this;
    }
}

