/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.data;

import com.kenshoo.jooq.DataTable;
import com.kenshoo.jooq.FieldAndValue;
import com.kenshoo.pl.data.AbstractRecordCommand;
import com.kenshoo.pl.data.AffectedRows;
import com.kenshoo.pl.data.CreateRecordCommand;
import com.kenshoo.pl.data.DeleteRecordCommand;
import com.kenshoo.pl.data.GeneratedKeyRecorder;
import com.kenshoo.pl.data.UpdateRecordCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DeleteUsingStep;
import org.jooq.Field;
import org.jooq.Insert;
import org.jooq.InsertOnDuplicateSetStep;
import org.jooq.InsertValuesStepN;
import org.jooq.Query;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.True;
import org.jooq.UpdateSetFirstStep;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.jooq.lambda.Seq;

public class CommandsExecutor {
    private final DSLContext dslContext;

    public CommandsExecutor(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public static CommandsExecutor of(DSLContext dslContext) {
        return new CommandsExecutor(dslContext);
    }

    public AffectedRows executeInserts(DataTable table, Collection<? extends CreateRecordCommand> commands) {
        return this.executeCommands(commands, homogeneousCommands -> this.executeInsertCommands(table, homogeneousCommands, CreateRecordCommand.OnDuplicateKey.FAIL));
    }

    public AffectedRows executeInsertsOnDuplicateKeyIgnore(DataTable table, Collection<? extends CreateRecordCommand> commands) {
        return this.executeCommands(commands, homogeneousCommands -> this.executeInsertCommands(table, homogeneousCommands, CreateRecordCommand.OnDuplicateKey.IGNORE));
    }

    public AffectedRows executeInsertsOnDuplicateKeyUpdate(DataTable table, Collection<? extends CreateRecordCommand> commands) {
        return this.executeCommands(commands, homogeneousCommands -> this.executeInsertCommands(table, homogeneousCommands, CreateRecordCommand.OnDuplicateKey.UPDATE));
    }

    public AffectedRows executeUpdates(DataTable table, Collection<? extends UpdateRecordCommand> commands) {
        return this.executeCommands(commands, homogeneousCommands -> this.executeUpdateCommands(table, homogeneousCommands));
    }

    public AffectedRows executeDeletes(DataTable table, Collection<? extends DeleteRecordCommand> commands) {
        if (commands.isEmpty()) {
            return AffectedRows.empty();
        }
        return this.executeDeleteCommands(table, commands);
    }

    private <C extends AbstractRecordCommand> AffectedRows executeCommands(Collection<? extends C> commands, HomogeneousChunkExecutor<C> homogeneousChunkExecutor) {
        AffectedRows updated = AffectedRows.empty();
        LinkedList<C> commandsLeft = new LinkedList<C>(commands);
        while (!commandsLeft.isEmpty()) {
            AbstractRecordCommand firstCommand = (AbstractRecordCommand)commandsLeft.remove(0);
            ArrayList<AbstractRecordCommand> commandsToExecute = new ArrayList<AbstractRecordCommand>(Collections.singletonList(firstCommand));
            Set<String> firstCommandFields = this.getFieldsNames(firstCommand);
            Iterator iterator = commandsLeft.iterator();
            while (iterator.hasNext()) {
                AbstractRecordCommand command = (AbstractRecordCommand)iterator.next();
                if (!this.getFieldsNames(command).equals(firstCommandFields)) continue;
                commandsToExecute.add(command);
                iterator.remove();
            }
            updated = updated.plus(homogeneousChunkExecutor.execute(commandsToExecute));
        }
        return updated;
    }

    private AffectedRows executeDeleteCommands(DataTable table, Collection<? extends DeleteRecordCommand> commandsToExecute) {
        DeleteUsingStep delete = this.dslContext.delete((Table)table);
        Iterator<? extends DeleteRecordCommand> commandIt = commandsToExecute.iterator();
        DeleteRecordCommand command = commandIt.next();
        True condition = DSL.trueCondition();
        TableField<?, ?>[] tableFields = command.getId().getTableFields();
        for (TableField<?, ?> id : tableFields) {
            condition = condition.and(id.eq(null));
        }
        for (FieldAndValue fieldAndValue : table.getVirtualPartition()) {
            condition = condition.and(fieldAndValue.getField().eq(null));
        }
        delete.where((Condition)condition);
        BatchBindStep batch = this.dslContext.batch((Query)delete);
        while (command != null) {
            List list = Stream.concat(Stream.of(command.getId().getValues()), table.getVirtualPartition().stream().map(FieldAndValue::getValue)).collect(Collectors.toList());
            batch.bind(list.toArray());
            command = commandIt.hasNext() ? commandIt.next() : null;
        }
        return AffectedRows.deleted(IntStream.of(batch.execute()).sum());
    }

    /*
     * WARNING - void declaration
     */
    private AffectedRows executeUpdateCommands(DataTable table, List<? extends UpdateRecordCommand> commandsToExecute) {
        void var10_14;
        UpdateSetFirstStep update1 = this.dslContext.update((Table)table);
        UpdateSetMoreStep update = null;
        UpdateRecordCommand command1 = commandsToExecute.get(0);
        if (!command1.getFields().findFirst().isPresent()) {
            return AffectedRows.empty();
        }
        for (Field field : Seq.seq(command1.getFields())) {
            if (update != null) {
                update = update.set(field, null);
                continue;
            }
            update = update1.set(field, null);
        }
        assert (update != null);
        True condition = DSL.trueCondition();
        TableField<?, ?>[] tableFields = command1.getId().getTableFields();
        TableField<?, ?>[] tableFieldArray = tableFields;
        int n = tableFieldArray.length;
        boolean bl = false;
        while (var10_14 < n) {
            TableField<?, ?> id = tableFieldArray[var10_14];
            condition = condition.and(id.eq(null));
            ++var10_14;
        }
        for (FieldAndValue fieldAndValue : table.getVirtualPartition()) {
            condition = condition.and(fieldAndValue.getField().eq(null));
        }
        update.where((Condition)condition);
        BatchBindStep batch = this.dslContext.batch((Query)update);
        for (UpdateRecordCommand updateRecordCommand : commandsToExecute) {
            List values = Stream.of(updateRecordCommand.getValues(command1.getFields()), Stream.of(updateRecordCommand.getId().getValues()), table.getVirtualPartition().stream().map(FieldAndValue::getValue)).flatMap(s -> s).collect(Collectors.toList());
            batch.bind(values.toArray());
        }
        int[] nArray = batch.execute();
        return AffectedRows.updated(IntStream.of(nArray).sum());
    }

    private AffectedRows executeInsertCommands(DataTable table, List<? extends CreateRecordCommand> commandsToExecute, CreateRecordCommand.OnDuplicateKey onDuplicateKey) {
        InsertValuesStepN insertValuesStepN;
        Optional<GeneratedKeyRecorder> generatedKeyRecorder = Optional.ofNullable(table.getIdentity()).map(identity -> new GeneratedKeyRecorder((Field<?>)identity.getField(), commandsToExecute.size()));
        DSLContext dslContext = generatedKeyRecorder.map(g -> g.newRecordingJooq(this.dslContext)).orElse(this.dslContext);
        CreateRecordCommand firstCommand = commandsToExecute.get(0);
        Collection fields = Stream.concat(firstCommand.getFields(), table.getVirtualPartition().stream().map(FieldAndValue::getField)).collect(Collectors.toList());
        InsertValuesStepN insert = insertValuesStepN = dslContext.insertInto((Table)table, fields).values(new Object[fields.size()]);
        switch (onDuplicateKey) {
            case IGNORE: {
                insert = insertValuesStepN.onDuplicateKeyIgnore();
                break;
            }
            case UPDATE: {
                InsertOnDuplicateSetStep insertOnDuplicateSetStep = insertValuesStepN.onDuplicateKeyUpdate();
                for (Field field : Seq.seq(firstCommand.getFields())) {
                    insertOnDuplicateSetStep = insertOnDuplicateSetStep.set(field, null);
                }
                insert = (Insert)insertOnDuplicateSetStep;
            }
        }
        BatchBindStep batch = dslContext.batch((Query)insert);
        for (AbstractRecordCommand abstractRecordCommand : commandsToExecute) {
            List values = Stream.concat(abstractRecordCommand.getValues(firstCommand.getFields()), table.getVirtualPartition().stream().map(FieldAndValue::getValue)).collect(Collectors.toList());
            if (onDuplicateKey == CreateRecordCommand.OnDuplicateKey.UPDATE) {
                values = Stream.concat(values.stream(), values.stream()).collect(Collectors.toList());
            }
            batch.bind(values.toArray());
        }
        int[] result = batch.execute();
        int n = (int)IntStream.of(result).filter(i -> i == 1 || i == -2).count();
        int updated = (int)IntStream.of(result).filter(i -> i == 2).count();
        generatedKeyRecorder.map(GeneratedKeyRecorder::getGeneratedKeys).ifPresent(generatedKeys -> this.setIdsToCommands((Field)table.getIdentity().getField(), commandsToExecute, (List<Object>)generatedKeys));
        return AffectedRows.insertedAndUpdated(n, updated);
    }

    private void setIdsToCommands(Field idField, List<? extends CreateRecordCommand> commandsToExecute, List<Object> generatedKeys) {
        Seq.seq(commandsToExecute).zip(generatedKeys).forEach(pair -> ((CreateRecordCommand)pair.v1).set(idField, pair.v2));
    }

    private Set<String> getFieldsNames(AbstractRecordCommand command) {
        return command.getFields().map(Field::getName).collect(Collectors.toSet());
    }

    @FunctionalInterface
    static interface HomogeneousChunkExecutor<C extends AbstractRecordCommand> {
        public AffectedRows execute(List<C> var1);
    }
}

