/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.jooq;

import com.kenshoo.jooq.TablePopulator;
import org.jooq.BatchBindStep;
import org.jooq.Constraint;
import org.jooq.CreateTableColumnStep;
import org.jooq.DSLContext;
import org.jooq.DropTableStep;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;

class TempTable<T extends Table<Record>> {
    private final DSLContext dslContext;
    private final T table;
    private final Field<?>[] fields;
    private final Type tableType;
    private final TablePopulator tablePopulator;

    public TempTable(DSLContext dslContext, T table, Field<?>[] fields, TablePopulator tablePopulator, Type tableType) {
        this.dslContext = dslContext;
        this.table = table;
        this.fields = fields;
        this.tableType = tableType;
        this.tablePopulator = tablePopulator;
    }

    public void create() {
        this.dropTable();
        this.createTable();
        this.populateTable();
    }

    public void dropTable() {
        DropTableStep dropTable = this.dslContext.dropTableIfExists(this.table);
        this.dslContext.execute(dropTable.getSQL().replace("drop table", "drop temporary table"));
    }

    private void createTable() {
        CreateTableColumnStep createTableColumnStep = this.dslContext.createTemporaryTable(this.table).column(this.fields[0]);
        for (int i = 1; i < this.fields.length; ++i) {
            Field<?> field = this.fields[i];
            createTableColumnStep = createTableColumnStep.column(field, field.getDataType());
        }
        CreateTableColumnStep createTableFinalStep = createTableColumnStep;
        UniqueKey primaryKey = this.table.getPrimaryKey();
        if (primaryKey != null) {
            createTableFinalStep = createTableColumnStep.constraint((Constraint)DSL.constraint().unique((Field[])primaryKey.getFields().toArray(new TableField[0])));
        }
        String tableCreateSql = createTableFinalStep.getSQL();
        if (this.tableType == Type.IN_MEMORY) {
            tableCreateSql = tableCreateSql.concat(" Engine=MEMORY");
        }
        this.dslContext.execute(tableCreateSql);
    }

    private void populateTable() {
        BatchBindStep batch = this.dslContext.batch((Query)this.dslContext.insertInto(this.table, this.fields).values(new Object[this.fields.length]).onDuplicateKeyIgnore());
        this.tablePopulator.populate(batch);
        batch.execute();
    }

    static enum Type {
        IN_MEMORY,
        REGULAR;

    }
}

