/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.jooq;

import com.google.common.base.Preconditions;
import com.kenshoo.jooq.FieldAndValues;
import com.kenshoo.jooq.QueryExtension;
import com.kenshoo.jooq.TempTableCreator;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.SelectFinalStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectWhereStep;

class QueryExtensionImpl<Q extends SelectFinalStep>
implements QueryExtension<Q> {
    private final Q query;
    private TempTableCreator tempTableCreator;

    QueryExtensionImpl(DSLContext dslContext, Q query, List<FieldAndValues<?>> fieldsWithValues) {
        this.tempTableCreator = new TempTableCreator(dslContext, fieldsWithValues);
        if (this.shouldUseTempTable(fieldsWithValues)) {
            Preconditions.checkArgument((boolean)(query instanceof SelectJoinStep), (Object)("Expected " + SelectJoinStep.class.getName() + " but got " + query.getClass().getName()));
            this.query = this.tempTableCreator.getJoinToTempTableClause((SelectJoinStep)query, fieldsWithValues);
        } else {
            Preconditions.checkArgument((boolean)(query instanceof SelectWhereStep), (Object)("Expected " + SelectWhereStep.class.getName() + " but got " + query.getClass().getName()));
            FieldAndValues<?> firstFieldAndValues = fieldsWithValues.get(0);
            this.query = this.addWhereToQuery((SelectWhereStep)query, firstFieldAndValues);
        }
    }

    private Q addWhereToQuery(SelectWhereStep query, FieldAndValues<?> firstFieldAndValues) {
        return (Q)query.where(firstFieldAndValues.getField().in(firstFieldAndValues.getValues()));
    }

    private boolean shouldUseTempTable(List<FieldAndValues<?>> fieldsWithValues) {
        return fieldsWithValues.size() > 1 || fieldsWithValues.get(0).getValues().size() > JOIN_TEMP_TABLE_LIMIT;
    }

    @Override
    public Q getQuery() {
        return this.query;
    }

    @Override
    public void close() {
        this.tempTableCreator.close();
    }
}

