/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.spi.helpers;

import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.PLCondition;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.UniqueKey;
import com.kenshoo.pl.entity.ValidationError;
import com.kenshoo.pl.entity.internal.EntitiesFetcher;
import com.kenshoo.pl.entity.internal.EntityWithNullForMissingField;
import com.kenshoo.pl.entity.spi.ChangesValidator;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public class MaxCountValidator<E extends EntityType<E>>
implements ChangesValidator<E> {
    private final String errorCode;
    private final EntitiesFetcher fetcher;
    private final UniqueKey<?> groupingKey;
    private final E entityType;
    private final PLCondition condition;
    private final int maxAllowed;

    private MaxCountValidator(E entityType, EntitiesFetcher fetcher, UniqueKey<?> uniqueKey, PLCondition condition, int maxAllowed, String errorCode) {
        this.errorCode = errorCode;
        this.entityType = (EntityType)Objects.requireNonNull(entityType, "entityType must be provided");
        this.fetcher = Objects.requireNonNull(fetcher, "entities fetcher must be provided");
        this.groupingKey = Objects.requireNonNull(uniqueKey, "grouping key must be provided");
        this.condition = Objects.requireNonNull(condition, "condition must be provided");
        if (maxAllowed < 1) {
            throw new IllegalArgumentException("maxAllowed must be greater than zero");
        }
        this.maxAllowed = maxAllowed;
    }

    @Override
    public SupportedChangeOperation getSupportedChangeOperation() {
        return SupportedChangeOperation.CREATE;
    }

    @Override
    public void validate(Collection<? extends EntityChange<E>> commands, ChangeOperation op, ChangeContext ctx) {
        Seq commandsToValidate = Seq.seq(commands).filter(command -> this.condition.getPostFetchCondition().test(ctx.getFinalEntity((EntityChange<? extends EntityType<?>>)command)));
        Map groupedCommands = Seq.seq((Seq)commandsToValidate).groupBy(cmd -> MaxCountValidator.createKeyValue(cmd, ctx, this.groupingKey));
        Map<Identifier<?>, Integer> countsInDB = this.fetcher.fetchCount(this.entityType, groupedCommands.keySet(), this.condition);
        groupedCommands.forEach((groupId, changes) -> {
            int numOfValidCommands = this.maxAllowed - countsInDB.getOrDefault(groupId, 0);
            Seq.seq((Iterable)changes).skip((long)numOfValidCommands).forEach(cmd -> this.markFailure((EntityChange<E>)cmd, ctx));
        });
    }

    private void markFailure(EntityChange<E> cmd, ChangeContext ctx) {
        ctx.addValidationError(cmd, new ValidationError(this.errorCode));
    }

    private static <E extends EntityType<E>> Identifier<?> createKeyValue(EntityChange<E> cmd, ChangeContext ctx, UniqueKey<?> key) {
        return key.createIdentifier(new EntityWithNullForMissingField(ctx.getFinalEntity(cmd)));
    }

    @Override
    public Stream<? extends EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToUpdate, ChangeOperation op) {
        return Seq.concat((Stream[])new Stream[]{this.condition.getFields().stream(), Stream.of(this.groupingKey.getFields()), Stream.of(this.groupingKey.getEntityType().getPrimaryKey().getFields())});
    }

    public static class Builder<E extends EntityType<E>> {
        private final E entityType;
        private String errorCode = "MAX_COUNT_EXCEEDED";
        private final EntitiesFetcher fetcher;
        private final UniqueKey<?> groupingKey;
        private PLCondition condition = PLCondition.trueCondition();
        private int maxAllowed;

        public Builder(EntitiesFetcher fetcher, E entityType, UniqueKey<?> groupingKey) {
            this.entityType = entityType;
            this.fetcher = fetcher;
            this.groupingKey = groupingKey;
        }

        public Builder<E> setCondition(PLCondition condition) {
            this.condition = condition;
            return this;
        }

        public Builder<E> setErrorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder<E> setMaxAllowed(int maxAllowed) {
            this.maxAllowed = maxAllowed;
            return this;
        }

        public MaxCountValidator<E> build() {
            return new MaxCountValidator<E>(this.entityType, this.fetcher, this.groupingKey, this.condition, this.maxAllowed, this.errorCode);
        }
    }
}

