/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.fetch;

import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jooq.Record;
import org.jooq.Table;

public class OneToOneTableRelation {
    private final Table<Record> primary;
    private final Table<Record> secondary;

    private OneToOneTableRelation(Table<Record> primary, Table<Record> secondary) {
        this.primary = Objects.requireNonNull(primary, "A primary table must be specified");
        this.secondary = Objects.requireNonNull(secondary, "A secondary table must be specified");
    }

    public Table<Record> getPrimary() {
        return this.primary;
    }

    public Table<Record> getSecondary() {
        return this.secondary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneToOneTableRelation that = (OneToOneTableRelation)o;
        return new EqualsBuilder().append(this.primary, that.primary).append(this.secondary, that.secondary).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.primary).append(this.secondary).toHashCode();
    }

    public static class Builder {
        private Table<Record> primary;
        private Table<Record> secondary;

        public Builder primary(Table<Record> primary) {
            this.primary = primary;
            return this;
        }

        public Builder secondary(Table<Record> secondary) {
            this.secondary = secondary;
            return this;
        }

        public OneToOneTableRelation build() {
            return new OneToOneTableRelation(this.primary, this.secondary);
        }
    }
}

