/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.google.common.annotations.VisibleForTesting;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.annotation.audit.Audited;
import com.kenshoo.pl.entity.annotation.audit.NotAudited;
import com.kenshoo.pl.entity.audit.AuditTrigger;
import com.kenshoo.pl.entity.internal.EntityTypeReflectionUtil;
import com.kenshoo.pl.entity.internal.audit.AuditFieldNameResolver;
import com.kenshoo.pl.entity.internal.audit.AuditFieldValueFormatterResolver;
import com.kenshoo.pl.entity.internal.audit.AuditIndicator;
import com.kenshoo.pl.entity.internal.audit.AuditedField;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AuditedFieldResolver {
    public static final AuditedFieldResolver INSTANCE = new AuditedFieldResolver(AuditFieldNameResolver.INSTANCE, AuditFieldValueFormatterResolver.INSTANCE);
    private final AuditFieldNameResolver fieldNameResolver;
    private final AuditFieldValueFormatterResolver fieldValueFormatterResolver;

    @VisibleForTesting
    AuditedFieldResolver(AuditFieldNameResolver auditFieldNameResolver, AuditFieldValueFormatterResolver fieldValueFormatterResolver) {
        this.fieldNameResolver = auditFieldNameResolver;
        this.fieldValueFormatterResolver = fieldValueFormatterResolver;
    }

    public <E extends EntityType<E>> Optional<AuditedField<E, ?>> resolve(EntityField<E, ?> field, AuditIndicator entityAuditIndicator) {
        Objects.requireNonNull(field, "field is required");
        Objects.requireNonNull(entityAuditIndicator, "entityAuditIndicator is required");
        return Optional.of(field).filter(Predicate.not(EntityField::isVirtual)).filter(f -> !EntityTypeReflectionUtil.isAnnotatedWith(f.getEntityType(), NotAudited.class, f)).filter(f -> EntityTypeReflectionUtil.isAnnotatedWith(f.getEntityType(), Audited.class, f) || entityAuditIndicator == AuditIndicator.AUDITED).map(this::toAuditedField);
    }

    private <E extends EntityType<E>> AuditedField<E, ?> toAuditedField(EntityField<E, ?> field) {
        AuditedField.Builder<E, ?> auditedFieldBuilder = AuditedField.builder(field).withName(this.fieldNameResolver.resolve(field)).withValueFormatter(this.fieldValueFormatterResolver.resolve(field));
        this.resolveFieldTrigger(field).ifPresent(auditedFieldBuilder::withTrigger);
        return auditedFieldBuilder.build();
    }

    private <E extends EntityType<E>> Optional<AuditTrigger> resolveFieldTrigger(EntityField<E, ?> field) {
        return Optional.ofNullable(EntityTypeReflectionUtil.getFieldAnnotation(field.getEntityType(), field, Audited.class)).map(Audited::trigger);
    }
}

