/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.audit;

import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.internal.audit.AuditedEntityType;
import com.kenshoo.pl.entity.spi.CurrentStateConsumer;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public class AuditRequiredFieldsCalculator<E extends EntityType<E>>
implements CurrentStateConsumer<E> {
    private final AuditedEntityType<E> auditedEntityType;

    public AuditRequiredFieldsCalculator(AuditedEntityType<E> auditedEntityType) {
        this.auditedEntityType = Objects.requireNonNull(auditedEntityType, "auditedEntityType is required");
    }

    @Override
    public Stream<? extends EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToChange, ChangeOperation changeOperation) {
        Set onChangeFields = this.auditedEntityType.getUnderlyingOnChangeFields().collect(Collectors.toUnmodifiableSet());
        Seq intersectedChangeFields = Seq.seq(fieldsToChange).filter(onChangeFields::contains);
        return Seq.seq(this.auditedEntityType.getUnderlyingMandatoryFields()).append(intersectedChangeFields).append(this.auditedEntityType.getIdField());
    }
}

