/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.kenshoo.jooq.DataTable;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.ValueConverter;
import com.kenshoo.pl.entity.converters.IdentityValueConverter;
import com.kenshoo.pl.entity.internal.EntityFieldImpl;
import com.kenshoo.pl.entity.internal.SimpleEntityFieldDbAdapter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jooq.ForeignKey;
import org.jooq.Record;
import org.jooq.TableField;
import org.jooq.lambda.Seq;

class SecondaryTableRelationExtractor {
    SecondaryTableRelationExtractor() {
    }

    static <E extends EntityType<E>> Stream<EntityField<E, ?>> relationUsingTableFieldsOfSecondary(DataTable secondaryTable, E entityType) {
        ForeignKey<Record, Record> foreignKey = secondaryTable.getForeignKey(entityType.getPrimaryTable());
        Seq primaryAndSecondaryFieldPairs = Seq.seq((Iterable)foreignKey.getKey().getFields()).zip((Iterable)foreignKey.getFields());
        return primaryAndSecondaryFieldPairs.map(ps -> entityType.findField((TableField)ps.v2).orElseGet(() -> SecondaryTableRelationExtractor.createTemporaryEntityField(entityType, (TableField)ps.v2, (TableField)ps.v1)));
    }

    private static <T, E extends EntityType<E>> EntityField<E, ?> createTemporaryEntityField(E entityType, TableField<Record, T> secondaryField, TableField<?, ?> primaryTableField) {
        EntityField<E, ?> primaryField = entityType.findField(primaryTableField).get();
        ValueConverter converter = IdentityValueConverter.getInstance(secondaryField.getType());
        return new EntityFieldImpl(entityType, new SimpleEntityFieldDbAdapter(secondaryField, converter), primaryField.getStringValueConverter(), Objects::equals);
    }

    static <E extends EntityType<E>> Stream<? extends EntityField<E, ?>> relationUsingTableFieldsOfPrimary(DataTable secondaryTable, E entityType) {
        ForeignKey<Record, Record> foreignKey = secondaryTable.getForeignKey(entityType.getPrimaryTable());
        List primaryFields = foreignKey.getKey().getFields();
        return Seq.seq((Iterable)primaryFields).map(field -> entityType.findField((TableField)field).orElseThrow(() -> new IllegalStateException(String.format("field %s is a FK from table %s to %s but is not defined on entity type %s.", field, secondaryTable.getName(), entityType.getPrimaryTable().getName(), entityType.getName()))));
    }
}

