/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal;

import com.google.common.collect.Sets;
import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.ChangeFlowConfig;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CurrentEntityMutableState;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FieldFetchRequest;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.Triptional;
import com.kenshoo.pl.entity.UniqueKeyValue;
import com.kenshoo.pl.entity.internal.EntitiesFetcher;
import com.kenshoo.pl.entity.internal.ForeignUniqueKey;
import com.kenshoo.pl.entity.internal.IsFieldReferringToParent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jooq.lambda.Seq;

public class EntitiesToContextFetcher {
    private final EntitiesFetcher entitiesFetcher;

    public EntitiesToContextFetcher(EntitiesFetcher entitiesFetcher) {
        this.entitiesFetcher = entitiesFetcher;
    }

    public <E extends EntityType<E>> void fetchEntities(Collection<? extends ChangeEntityCommand<E>> commands, ChangeOperation changeOperation, ChangeContext context, ChangeFlowConfig<E> flow) {
        commands.forEach(c -> context.addEntity((EntityChange)c, CurrentEntityState.EMPTY));
        Set<EntityField<?, ?>> fieldsToFetch = context.getFetchRequests().stream().filter(r -> r.getWhereToQuery().equals(flow.getEntityType()) && r.supports(changeOperation)).map(FieldFetchRequest::getEntityField).collect(Collectors.toSet());
        if (changeOperation == ChangeOperation.CREATE) {
            this.fetchEntitiesByForeignKeys(commands, fieldsToFetch, context, flow);
        } else {
            this.fetchEntitiesByKeys(commands, fieldsToFetch, context, flow);
        }
        this.populateFieldsFromAllParents(Seq.seq(commands).filter(this.notMissing(context)).toList(), context, (EntityType<E>)flow.getEntityType());
    }

    private <E extends EntityType<E>> void populateFieldsFromAllParents(List<? extends ChangeEntityCommand<E>> commands, ChangeContext context, EntityType<E> currentLevel) {
        if (commands.isEmpty()) {
            return;
        }
        Seq.seq(context.getFetchRequests()).filter(this.askedBy(currentLevel).and(this.not(this.queriedOn(currentLevel)))).groupBy(FieldFetchRequest::getWhereToQuery).forEach((level, requestedFields) -> {
            List parentFields = Seq.seq((Iterable)requestedFields).map(f -> f.getEntityField()).toList();
            commands.forEach(cmd -> this.populateFieldsFromOneLevel(context, (EntityType)level, parentFields, (ChangeEntityCommand)cmd));
        });
    }

    private <E extends EntityType<E>> void populateFieldsFromOneLevel(ChangeContext context, EntityType parentLevel, List<EntityField> parentFields, ChangeEntityCommand<E> cmd) {
        ChangeEntityCommand ancestor = this.getAncestor(cmd, parentLevel);
        CurrentEntityMutableState currentState = (CurrentEntityMutableState)context.getEntity(cmd);
        parentFields.forEach(field -> {
            Triptional<?> triptional = this.getValue(context, ancestor, (EntityField)field);
            if (triptional.isPresent()) {
                currentState.set(field, triptional.get());
            }
        });
    }

    private ChangeEntityCommand getAncestor(ChangeEntityCommand cmd, EntityType level) {
        for (ChangeEntityCommand<?> parent = cmd.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getEntityType().equals(level)) continue;
            return parent;
        }
        throw new RuntimeException("didn't find ancestor of level " + level.getName() + " for command with entity " + cmd.getEntityType().getName());
    }

    private Triptional<?> getValue(ChangeContext context, ChangeEntityCommand cmd, EntityField field) {
        return cmd.containsField(field) ? Triptional.of(cmd.get(field)) : context.getEntity(cmd).safeGet(field);
    }

    private Predicate<FieldFetchRequest> askedBy(EntityType e) {
        return r -> r.getWhoAskedForThis().equals(e);
    }

    private <T> Predicate<T> not(Predicate<T> p) {
        return p.negate();
    }

    private Predicate<FieldFetchRequest> queriedOn(EntityType e) {
        return r -> r.getWhereToQuery().equals(e);
    }

    private <E extends EntityType<E>> void fetchEntitiesByKeys(Collection<? extends ChangeEntityCommand<E>> commands, Set<EntityField<?, ?>> fieldsToFetch, ChangeContext changeContext, ChangeFlowConfig<E> flowConfig) {
        Map keysByCommand = commands.stream().collect(Collectors.toMap(Function.identity(), cmd -> UniqueKeyValue.concat(cmd.getIdentifier(), cmd.getKeysToParent())));
        Map fetchedEntities = this.entitiesFetcher.fetchEntitiesByIds(keysByCommand.values(), fieldsToFetch);
        this.addFetchedEntitiesToChangeContext(fetchedEntities, changeContext, keysByCommand);
    }

    private <E extends EntityType<E>> void fetchEntitiesByForeignKeys(Collection<? extends ChangeEntityCommand<E>> commands, Set<EntityField<?, ?>> fieldsToFetch, ChangeContext context, ChangeFlowConfig<E> flowConfig) {
        E entityType = flowConfig.getEntityType();
        Collection foreignKeys = entityType.determineForeignKeys(flowConfig.getRequiredRelationFields()).filter(this.not(new IsFieldReferringToParent(context.getHierarchy(), entityType))).collect(Collectors.toList());
        if (foreignKeys.isEmpty()) {
            commands.forEach(cmd -> context.addEntity((EntityChange)cmd, new CurrentEntityMutableState()));
        } else {
            ForeignUniqueKey foreignUniqueKey = new ForeignUniqueKey(foreignKeys);
            Map keysByCommand = commands.stream().collect(Collectors.toMap(Function.identity(), foreignUniqueKey::createIdentifier));
            Map<Identifier<E>, CurrentEntityState> fetchedEntities = this.entitiesFetcher.fetchEntitiesByForeignKeys(entityType, foreignUniqueKey, Sets.newHashSet(keysByCommand.values()), (Collection<EntityField<?, ?>>)fieldsToFetch);
            this.addFetchedEntitiesToChangeContext(fetchedEntities, context, keysByCommand);
        }
    }

    private <E extends EntityType<E>> void addFetchedEntitiesToChangeContext(Map<Identifier<E>, CurrentEntityState> fetchedEntities, ChangeContext changeContext, Map<? extends ChangeEntityCommand<E>, Identifier<E>> keysByCommand) {
        for (Map.Entry<ChangeEntityCommand<E>, Identifier<E>> entry : keysByCommand.entrySet()) {
            ChangeEntityCommand<E> command = entry.getKey();
            Identifier<E> identifier = entry.getValue();
            CurrentEntityState currentState = fetchedEntities.get(identifier);
            if (currentState == null) continue;
            changeContext.addEntity(command, currentState);
        }
    }

    private <E extends EntityType<E>> Predicate<ChangeEntityCommand<E>> notMissing(ChangeContext context) {
        return cmd -> context.getEntity((EntityChange)cmd) != CurrentEntityState.EMPTY;
    }
}

