/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Triptional<T> {
    private static final Triptional<?> NULL_INSTANCE = new Triptional(State.NULL);
    private static final Triptional<?> ABSENT_INSTANCE = new Triptional(State.ABSENT);
    private final T value;
    private final State state;

    private Triptional(State state) {
        this(null, state);
    }

    private Triptional(T value, State state) {
        this.value = value;
        this.state = state;
    }

    public static <T> Triptional<T> of(T value) {
        return value == null ? Triptional.nullInstance() : new Triptional<T>(value, State.NOT_NULL);
    }

    public static <T> Triptional<T> nullInstance() {
        return NULL_INSTANCE;
    }

    public static <T> Triptional<T> absent() {
        return ABSENT_INSTANCE;
    }

    public T get() {
        if (this.isAbsent()) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public void ifNotNull(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public <U> Triptional<U> map(Function<? super T, ? extends U> mapper) {
        return this.map(mapper, () -> null);
    }

    public <U> Triptional<U> map(Function<? super T, ? extends U> notNullMapper, Supplier<? extends U> nullReplacer) {
        Objects.requireNonNull(notNullMapper, "notNullMapper is required");
        Objects.requireNonNull(nullReplacer, "nullReplacer is required");
        switch (this.state) {
            case NOT_NULL: {
                return Triptional.of(notNullMapper.apply(this.value));
            }
            case NULL: {
                return Triptional.of(nullReplacer.get());
            }
        }
        return Triptional.absent();
    }

    public <U> Triptional<U> flatMap(Function<? super T, Triptional<U>> mapper) {
        return this.flatMap(mapper, Triptional::nullInstance);
    }

    public <U> Triptional<U> flatMap(Function<? super T, Triptional<U>> notNullMapper, Supplier<Triptional<U>> nullReplacer) {
        Objects.requireNonNull(notNullMapper, "notNullMapper is required");
        Objects.requireNonNull(nullReplacer, "nullReplacer is required");
        switch (this.state) {
            case NOT_NULL: {
                return Objects.requireNonNull(notNullMapper.apply(this.value));
            }
            case NULL: {
                return Objects.requireNonNull(nullReplacer.get());
            }
        }
        return Triptional.absent();
    }

    public Optional<T> asOptional() {
        return Optional.ofNullable(this.value);
    }

    public <U> Optional<U> mapToOptional(Function<? super T, ? extends U> mapper) {
        return this.mapToOptional(mapper, () -> null);
    }

    public <U> Optional<U> mapToOptional(Function<? super T, ? extends U> notNullMapper, Supplier<? extends U> nullReplacer) {
        return this.map(notNullMapper, nullReplacer).asOptional();
    }

    public Triptional<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "a predicate must be provided");
        if (this.matches(predicate)) {
            return this;
        }
        return Triptional.absent();
    }

    public boolean matches(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "a predicate must be provided");
        return this.isPresent() && predicate.test(this.value);
    }

    public boolean isPresent() {
        return !this.isAbsent();
    }

    public boolean isAbsent() {
        return this.state == State.ABSENT;
    }

    public boolean isNotNull() {
        return this.state == State.NOT_NULL;
    }

    public boolean isNullOrAbsent() {
        return this.isAbsent() || this.isNull();
    }

    public boolean isNull() {
        return this.state == State.NULL;
    }

    public boolean equalsValue(T value) {
        return this.isPresent() && Objects.equals(this.value, value);
    }

    public boolean equals(Object obj) {
        return this.equals(obj, Objects::equals);
    }

    public boolean equals(Object obj, BiFunction<T, T, Boolean> valueEqualityFunction) {
        Objects.requireNonNull(valueEqualityFunction, "A value equality function must be provided");
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Triptional)) {
            return false;
        }
        Triptional other = (Triptional)obj;
        if (!this.isPresent() || !other.isPresent()) {
            return false;
        }
        return valueEqualityFunction.apply(this.value, other.value);
    }

    public boolean equalsAsOptional(Object obj, BiFunction<T, T, Boolean> valueEqualityFunction) {
        Objects.requireNonNull(valueEqualityFunction, "A value equality function must be provided");
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Triptional)) {
            return false;
        }
        Triptional other = (Triptional)obj;
        return valueEqualityFunction.apply(this.value, other.value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.state).append(this.value).toHashCode();
    }

    public String toString() {
        switch (this.state) {
            case NOT_NULL: {
                return String.format("Triptional[%s]", this.value);
            }
            case NULL: {
                return "Triptional.null";
            }
        }
        return "Triptional.absent";
    }

    static enum State {
        NOT_NULL,
        NULL,
        ABSENT;

    }
}

