/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.UpdateEntityCommand;

public class InsertOnDuplicateUpdateCommand<E extends EntityType<E>, ID extends Identifier<E>>
extends UpdateEntityCommand<E, ID> {
    private ChangeOperation changeOperation = ChangeOperation.UPDATE;
    private boolean allowMissingEntity = true;

    public InsertOnDuplicateUpdateCommand(E entityType, ID key) {
        super(entityType, key);
    }

    @Override
    public ChangeOperation getChangeOperation() {
        return this.changeOperation;
    }

    @Override
    public boolean allowMissingEntity() {
        return this.allowMissingEntity;
    }

    @Override
    public void updateOperator(ChangeOperation changeOperation) {
        if (this.changeOperation != ChangeOperation.UPDATE || changeOperation != ChangeOperation.CREATE) {
            throw new UnsupportedOperationException("Unsupported update change operation from " + this.changeOperation + " to " + changeOperation);
        }
        this.changeOperation = changeOperation;
        this.allowMissingEntity = false;
        ChangeEntityCommand.copy(this, this.getIdentifier());
        this.getChildren().forEach(child -> child.updateOperator(changeOperation));
    }
}

