/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.collect.ImmutableList;
import com.kenshoo.pl.entity.ChangeEntityCommand;
import com.kenshoo.pl.entity.EntityChangeResult;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.PersistentLayerStats;
import com.kenshoo.pl.entity.ValidationError;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.lambda.Seq;

public class ChangeResult<E extends EntityType<E>, ID extends Identifier<E>, C extends ChangeEntityCommand<E>>
implements Iterable<EntityChangeResult<E, ID, C>> {
    private final Collection<EntityChangeResult<E, ID, C>> changeResults;
    private final Map<ChangeEntityCommand<E>, EntityChangeResult<E, ID, C>> resultsAsMap;
    private final PersistentLayerStats stats;

    public ChangeResult(Iterable<? extends EntityChangeResult<E, ID, C>> changeResults, PersistentLayerStats stats) {
        this.changeResults = ImmutableList.copyOf(changeResults);
        this.resultsAsMap = (Map)Seq.seq(this.changeResults).collect(Collectors.toMap(EntityChangeResult::getCommand, Function.identity()));
        this.stats = stats;
    }

    public boolean hasErrors() {
        return this.changeResults.stream().anyMatch(changeResult -> !changeResult.getErrors().isEmpty());
    }

    public boolean hasErrors(C command) {
        return !this.getErrors(command).isEmpty();
    }

    public Collection<ValidationError> getErrors(C command) {
        return this.resultsAsMap.get(command).getErrors();
    }

    @Override
    public Iterator<EntityChangeResult<E, ID, C>> iterator() {
        return this.changeResults.iterator();
    }

    public Collection<EntityChangeResult<E, ID, C>> getChangeResults() {
        return this.changeResults;
    }

    public PersistentLayerStats getStats() {
        return this.stats;
    }
}

