/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity;

import com.google.common.collect.Lists;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityFieldPrototype;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FieldChange;
import com.kenshoo.pl.entity.FieldsValueMap;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.TransientProperty;
import com.kenshoo.pl.entity.internal.EntityFieldImpl;
import com.kenshoo.pl.entity.internal.EntityTypeReflectionUtil;
import com.kenshoo.pl.entity.internal.LazyDelegatingMultiSupplier;
import com.kenshoo.pl.entity.internal.MissingChildrenSupplier;
import com.kenshoo.pl.entity.spi.CurrentStateConsumer;
import com.kenshoo.pl.entity.spi.FieldValueSupplier;
import com.kenshoo.pl.entity.spi.MultiFieldValueSupplier;
import com.kenshoo.pl.entity.spi.MutableCommand;
import com.kenshoo.pl.entity.spi.NotSuppliedException;
import com.kenshoo.pl.entity.spi.ValidationException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public abstract class ChangeEntityCommand<E extends EntityType<E>>
implements MutableCommand<E> {
    private final E entityType;
    private final Map<EntityField<E, ?>, Object> values = new HashMap();
    private final Map<TransientProperty<?>, Object> transientProperties = new HashMap(0);
    private final Map<EntityField<E, ?>, FieldValueSupplierDelegate<E, ?>> suppliers = new HashMap();
    private final List<ChangeEntityCommand<? extends EntityType>> children = Lists.newArrayListWithCapacity((int)1);
    private final List<MissingChildrenSupplier<? extends EntityType>> missingChildrenSuppliers = Lists.newArrayListWithCapacity((int)1);
    private ChangeEntityCommand parent;
    private Identifier<E> keysToParent;

    public ChangeEntityCommand(E entityType) {
        this.entityType = entityType;
    }

    @Override
    public E getEntityType() {
        return this.entityType;
    }

    @Override
    public <T> void set(EntityField<E, T> field, T newValue) {
        this.values.put(field, newValue);
    }

    @Override
    public <T> void set(EntityFieldPrototype<T> fieldPrototype, T newValue) {
        EntityField<E, T> entityField = this.findFieldByPrototype(fieldPrototype);
        this.set(entityField, newValue);
    }

    @Override
    public <T> void set(EntityField<E, T> field, FieldValueSupplier<T> valueSupplier) {
        this.suppliers.put(field, new SingleFieldValueSupplierDelegate(valueSupplier));
    }

    @Override
    public <T> void set(EntityFieldPrototype<T> fieldPrototype, FieldValueSupplier<T> valueSupplier) {
        EntityField<E, T> entityField = this.findFieldByPrototype(fieldPrototype);
        this.set(entityField, valueSupplier);
    }

    @Override
    public void set(Collection<EntityField<E, ?>> fields, MultiFieldValueSupplier<E> valueSupplier) {
        LazyDelegatingMultiSupplier<E> delegatingMultiSupplier = new LazyDelegatingMultiSupplier<E>(valueSupplier);
        for (EntityField<E, ?> field : fields) {
            this.addAsSingleValueSupplier(field, delegatingMultiSupplier);
        }
    }

    @Override
    public <T> void set(TransientProperty<T> transientProperty, T propertyValue) {
        Objects.requireNonNull(transientProperty, "A transient property must be provided");
        Objects.requireNonNull(propertyValue, "A property value must be provided");
        this.transientProperties.put(transientProperty, propertyValue);
    }

    private <T> void addAsSingleValueSupplier(EntityField<E, T> entityField, MultiFieldValueSupplier<E> delegatingSupplier) {
        this.suppliers.put(entityField, new MultiFieldValueSupplierDelegate<E, T>(delegatingSupplier, entityField));
    }

    @Override
    public Stream<EntityField<E, ?>> getChangedFields() {
        if (this.suppliers.isEmpty()) {
            return this.values.keySet().stream();
        }
        return Stream.concat(this.values.keySet().stream(), this.suppliers.keySet().stream()).distinct();
    }

    @Override
    public Stream<FieldChange<E, ?>> getChanges() {
        return this.values.entrySet().stream().map(entry -> new FieldChange((EntityField)entry.getKey(), entry.getValue()));
    }

    @Override
    public <T> boolean containsField(EntityField<E, T> field) {
        return this.isFieldChanged(field);
    }

    @Override
    public boolean isFieldChanged(EntityField<E, ?> field) {
        return this.values.containsKey(field);
    }

    @Override
    public <T> T get(EntityField<E, T> field) {
        Object value = this.values.get(field);
        if (value == null && !this.values.containsKey(field)) {
            throw new IllegalArgumentException("No value supplied for field " + field);
        }
        return (T)value;
    }

    @Override
    public <T> Optional<T> get(TransientProperty<T> transientProperty) {
        Objects.requireNonNull(transientProperty, "A transient property must be specified");
        return Optional.ofNullable(this.transientProperties.get(transientProperty)).map(transientVal -> transientVal);
    }

    @Override
    public <CHILD extends EntityType<CHILD>> void addChild(ChangeEntityCommand<CHILD> childCmd) {
        this.children.add(childCmd);
        childCmd.parent = this;
    }

    @Override
    public <CHILD extends EntityType<CHILD>> Stream<ChangeEntityCommand<CHILD>> getChildren(CHILD type) {
        return this.children.stream().filter(cmd -> cmd.getEntityType() == type).map(cmd -> cmd);
    }

    @Override
    public Stream<ChangeEntityCommand<? extends EntityType>> getChildren() {
        return this.children.stream();
    }

    void unset(EntityField<E, ?> field) {
        this.values.remove(field);
    }

    void resolveSuppliers(CurrentEntityState currentState) throws ValidationException {
        if (this.suppliers.isEmpty()) {
            return;
        }
        for (Map.Entry<EntityField<E, ?>, FieldValueSupplierDelegate<E, ?>> entry : this.suppliers.entrySet()) {
            try {
                this.values.put(entry.getKey(), entry.getValue().supply(currentState));
            }
            catch (NotSuppliedException notSuppliedException) {}
        }
    }

    Stream<? extends CurrentStateConsumer<E>> getCurrentStateConsumers() {
        if (this.suppliers.isEmpty()) {
            return Stream.empty();
        }
        return this.suppliers.values().stream().distinct();
    }

    private <T> EntityField<E, T> findFieldByPrototype(EntityFieldPrototype<T> fieldPrototype) {
        Set<EntityField<E, T>> entityFields = EntityTypeReflectionUtil.getFieldsByPrototype(this.entityType, fieldPrototype);
        if (entityFields.isEmpty()) {
            throw new IllegalArgumentException("Entity " + this.entityType + " doesn't have a field with prototype " + fieldPrototype);
        }
        if (entityFields.size() > 1) {
            throw new IllegalStateException("Entity " + this.entityType + " has more than one field with prototype " + fieldPrototype);
        }
        return entityFields.iterator().next();
    }

    static <E extends EntityType<E>> void copy(ChangeEntityCommand<E> toCommand, Identifier<E> identifier) {
        ChangeEntityCommand.copyFields(toCommand, identifier.getUniqueKey().getFields(), identifier);
    }

    private static <E extends EntityType<E>> void copyFields(ChangeEntityCommand<E> toCommand, EntityField<E, ?>[] fields, FieldsValueMap<E> fieldsValueMap) {
        Stream.of(fields).map(field -> (EntityFieldImpl)field).forEach(field -> toCommand.set((EntityField)field, fieldsValueMap.get(field)));
    }

    @Override
    public Identifier<E> getKeysToParent() {
        return this.keysToParent;
    }

    void setKeysToParent(Identifier<E> keysToParent) {
        this.keysToParent = keysToParent;
    }

    public void updateOperator(ChangeOperation changeOperation) {
    }

    public ChangeEntityCommand<?> getParent() {
        return this.parent;
    }

    @Override
    public void add(MissingChildrenSupplier<? extends EntityType> missingChildrenSupplier) {
        this.missingChildrenSuppliers.add(missingChildrenSupplier);
    }

    List<MissingChildrenSupplier<? extends EntityType>> getMissingChildrenSuppliers() {
        return this.missingChildrenSuppliers;
    }

    <CHILD extends EntityType<CHILD>> Optional<MissingChildrenSupplier<CHILD>> getMissingChildrenSupplier(CHILD entityType) {
        Optional missingChildrenSupplier = Seq.seq(this.missingChildrenSuppliers).findFirst(supplier -> entityType.equals(supplier.getChildType()));
        return missingChildrenSupplier.map(supplier -> supplier);
    }

    private static class MultiFieldValueSupplierDelegate<E extends EntityType<E>, T>
    implements FieldValueSupplierDelegate<E, T> {
        private final MultiFieldValueSupplier<E> multiValueSupplier;
        private final EntityField<E, T> entityField;

        private MultiFieldValueSupplierDelegate(MultiFieldValueSupplier<E> supplier, EntityField<E, T> entityField) {
            this.multiValueSupplier = supplier;
            this.entityField = entityField;
        }

        @Override
        public T supply(CurrentEntityState currentState) throws ValidationException {
            FieldsValueMap<E> result = this.multiValueSupplier.supply(currentState);
            if (result.containsField(this.entityField)) {
                return result.get(this.entityField);
            }
            throw new NotSuppliedException();
        }

        @Override
        public Stream<EntityField<?, ?>> fetchFields(ChangeOperation changeOperation) {
            return this.multiValueSupplier.fetchFields(changeOperation);
        }

        @Override
        public Stream<? extends EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToUpdate, ChangeOperation changeOperation) {
            return this.fetchFields(changeOperation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiFieldValueSupplierDelegate that = (MultiFieldValueSupplierDelegate)o;
            return Objects.equals(this.multiValueSupplier, that.multiValueSupplier);
        }

        public int hashCode() {
            return Objects.hash(this.multiValueSupplier);
        }
    }

    private static class SingleFieldValueSupplierDelegate<E extends EntityType<E>, T>
    implements FieldValueSupplierDelegate<E, T> {
        private final FieldValueSupplier<T> valueSupplier;

        private SingleFieldValueSupplierDelegate(FieldValueSupplier<T> supplier) {
            this.valueSupplier = supplier;
        }

        @Override
        public T supply(CurrentEntityState currentState) throws ValidationException, NotSuppliedException {
            return this.valueSupplier.supply(currentState);
        }

        @Override
        public Stream<EntityField<?, ?>> fetchFields(ChangeOperation changeOperation) {
            return this.valueSupplier.fetchFields(changeOperation);
        }

        @Override
        public Stream<? extends EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToUpdate, ChangeOperation changeOperation) {
            return this.fetchFields(changeOperation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleFieldValueSupplierDelegate that = (SingleFieldValueSupplierDelegate)o;
            return Objects.equals(this.valueSupplier, that.valueSupplier);
        }

        public int hashCode() {
            return Objects.hash(this.valueSupplier);
        }
    }

    static interface FieldValueSupplierDelegate<E extends EntityType<E>, T>
    extends FieldValueSupplier<T>,
    CurrentStateConsumer<E> {
    }
}

