/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListenerProvider;
import org.jooq.Field;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteListener;

class GeneratedKeyRecorder
extends DefaultExecuteListener {
    private final Field generatedIdField;
    private final List<Object> generatedKeys;

    public DSLContext newRecordingJooq(DSLContext oldJooq) {
        DSLContext newJooq = DSL.using((Configuration)oldJooq.configuration().derive());
        Object[] originalListenerProviders = Optional.ofNullable(oldJooq.configuration().executeListenerProviders()).orElse(new ExecuteListenerProvider[0]);
        ExecuteListenerProvider[] newListenerProviders = (ExecuteListenerProvider[])ArrayUtils.addAll((Object[])originalListenerProviders, (Object[])new ExecuteListenerProvider[]{() -> this});
        newJooq.configuration().set(newListenerProviders);
        return newJooq;
    }

    public GeneratedKeyRecorder(Field<?> generatedIdField, int capacity) {
        this.generatedIdField = generatedIdField;
        this.generatedKeys = new ArrayList<Object>(capacity);
    }

    public List<Object> getGeneratedKeys() {
        return this.generatedKeys;
    }

    public void prepareEnd(ExecuteContext ctx) {
        try {
            PreparedStatement preparedStatement = ctx.connection().prepareStatement(ctx.sql(), 1);
            ctx.statement(preparedStatement);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void executeEnd(ExecuteContext ctx) {
        try (ResultSet fromDB = ctx.statement().getGeneratedKeys();){
            while (fromDB.next()) {
                this.generatedKeys.add(fromDB.getObject("GENERATED_KEY", this.generatedIdField.getType()));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

