/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.data;

import com.kenshoo.jooq.DataTable;
import gnu.trove.map.hash.THashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableField;
import org.jooq.UniqueKey;

public abstract class AbstractRecordCommand {
    private final DataTable table;
    private final Map<Field<?>, Object> values = new THashMap();

    protected AbstractRecordCommand(DataTable table) {
        this.table = table;
    }

    public <T> void set(Field<T> field, T value) {
        this.values.put(field, value);
    }

    public <T> T get(Field<T> field) {
        return (T)this.values.get(field);
    }

    public Stream<Field<?>> getFields() {
        return this.values.keySet().stream();
    }

    public Stream<Object> getValues(Stream<Field<?>> fields) {
        return fields.map(this.values::get);
    }

    public DataTable getTable() {
        return this.table;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    protected static TableField<Record, ?> getPrimaryKeyField(DataTable table, Class dataType) {
        UniqueKey primaryKey = table.getPrimaryKey();
        if (primaryKey == null) {
            throw new IllegalArgumentException("Table " + table + " doesn't have a primary key");
        }
        List primaryKeyFields = primaryKey.getFields();
        TableField primaryKeyField = (TableField)primaryKeyFields.get(0);
        if (primaryKeyFields.size() > 1 || primaryKeyField.getType() != dataType) {
            throw new IllegalArgumentException("Primary key of table " + table.getName() + " is not of type " + dataType.getSimpleName());
        }
        return primaryKeyField;
    }
}

