/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.utils.request;

import com.kaltura.client.Params;
import com.kaltura.client.enums.ResponseType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ListResponse;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.request.BaseRequestBuilder;
import com.kaltura.client.utils.request.ContentRequestBuilder;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.response.OnCompletion;
import com.kaltura.client.utils.response.base.Response;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;

public abstract class RequestBuilder<ReturnedType, TokenizerType, SelfType>
extends BaseRequestBuilder<ReturnedType, SelfType> {
    protected String id;
    protected String service;
    protected String action;

    public RequestBuilder(Class<ReturnedType> type, String service, String action) {
        super(type);
        this.service = service;
        this.action = action;
    }

    protected static <I> I getTokenizer(Class<I> intrface, String prefix) {
        Class<?>[] parentInterfaces = intrface.getInterfaces();
        Class[] interfaces = new Class[parentInterfaces.length + 1];
        for (int i = 0; i < parentInterfaces.length; ++i) {
            interfaces[i] = parentInterfaces[i];
        }
        interfaces[parentInterfaces.length] = intrface;
        return (I)Proxy.newProxyInstance(intrface.getClassLoader(), interfaces, (InvocationHandler)new Tokenizer(prefix));
    }

    public TokenizerType getTokenizer() throws APIException {
        if (this.id == null) {
            throw new APIException(APIException.FailureStep.OnRequest, "Request is not part of multi-request");
        }
        if (ObjectBase.class.isAssignableFrom(this.type)) {
            MultiRequestBuilder.Tokenizer annotation = this.type.getAnnotation(MultiRequestBuilder.Tokenizer.class);
            Class<?>[] parentInterfaces = annotation.value().getInterfaces();
            Class[] interfaces = new Class[parentInterfaces.length + 1];
            for (int i = 0; i < parentInterfaces.length; ++i) {
                interfaces[i] = parentInterfaces[i];
            }
            interfaces[parentInterfaces.length] = annotation.value();
            return (TokenizerType)Proxy.newProxyInstance(this.type.getClassLoader(), interfaces, (InvocationHandler)new Tokenizer(this.id + ":result"));
        }
        return (TokenizerType)("{" + this.id + ":result}");
    }

    public MultiRequestBuilder add(RequestBuilder<?, ?, ?> another) throws APIException {
        try {
            return new MultiRequestBuilder(this, another);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new MultiRequestBuilder();
        }
    }

    protected String getAction() {
        return this.action;
    }

    @Override
    protected Params getParams() {
        return this.params;
    }

    protected String getService() {
        return this.service;
    }

    @Override
    protected String getUrlTail() {
        StringBuilder urlBuilder = new StringBuilder("service/").append(this.service);
        if (!this.action.equals("")) {
            urlBuilder.append("/action/").append(this.action);
        }
        return urlBuilder.toString();
    }

    protected SelfType link(String destKey, String requestId, String sourceKey) {
        this.params.link(destKey, requestId, sourceKey);
        return (SelfType)this;
    }

    protected SelfType setId(String id) {
        this.id = id;
        return (SelfType)this;
    }

    protected String getId() {
        return this.id;
    }

    public SelfType setCompletion(OnCompletion<Response<ReturnedType>> onCompletion) {
        this.onCompletion = onCompletion;
        return (SelfType)this;
    }

    @Override
    public String getTag() {
        return this.service + "." + this.action;
    }

    public String toString() {
        return String.format("{\"service\":\"%s\",\"action\":\"%s\",\"type\":\"%s\",\"params\":%s}", this.service, this.action, this.type, this.params);
    }

    public ContentRequestBuilder setResponseFormat(ResponseType format) {
        return new ContentRequestBuilder(this, format);
    }

    public static class MapTokenizer<I> {
        private Class<I> intrface;
        private String prefix;

        public static <J> MapTokenizer<J> newInstance(Class<J> intrface, String prefix) {
            return new MapTokenizer<J>(intrface, prefix);
        }

        public MapTokenizer(Class<I> intrface, String prefix) {
            this.intrface = intrface;
            this.prefix = prefix;
        }

        public I get(String key) {
            return RequestBuilder.getTokenizer(this.intrface, this.prefix + ":" + key);
        }

        public <J extends I> J get(String key, Class<J> tokenizerInterface) {
            return RequestBuilder.getTokenizer(tokenizerInterface, this.prefix + ":" + key);
        }
    }

    public static class ListTokenizer<I> {
        private Class<I> intrface;
        private String prefix;

        public static <J> ListTokenizer<J> newInstance(Class<J> intrface, String prefix) {
            return new ListTokenizer<J>(intrface, prefix);
        }

        public ListTokenizer(Class<I> intrface, String prefix) {
            this.intrface = intrface;
            this.prefix = prefix;
        }

        public I get(int index) {
            return RequestBuilder.getTokenizer(this.intrface, this.prefix + ":" + index);
        }
    }

    public static class ListResponseTokenizer<I>
    implements ListResponse.Tokenizer<I> {
        private Class<I> intrface;
        private String prefix;

        public ListResponseTokenizer(Class<I> intrface, String prefix) {
            this.intrface = intrface;
            this.prefix = prefix;
        }

        @Override
        public String totalCount() {
            return "{" + this.prefix + ":totalCount}";
        }

        @Override
        public ListTokenizer<I> objects() {
            return ListTokenizer.newInstance(this.intrface, this.prefix + ":objects");
        }
    }

    public static class Tokenizer
    implements InvocationHandler {
        private String prefix;

        public Tokenizer(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String token = this.prefix + ":" + method.getName();
            if (method.getReturnType().isInterface()) {
                return RequestBuilder.getTokenizer(method.getReturnType(), token);
            }
            if (ListTokenizer.class.isAssignableFrom(method.getReturnType())) {
                ParameterizedType genericReturnType = (ParameterizedType)method.getGenericReturnType();
                Class intrface = (Class)genericReturnType.getActualTypeArguments()[0];
                return ListTokenizer.newInstance(intrface, token);
            }
            if (MapTokenizer.class.isAssignableFrom(method.getReturnType())) {
                ParameterizedType genericReturnType = (ParameterizedType)method.getGenericReturnType();
                Class intrface = (Class)genericReturnType.getActualTypeArguments()[0];
                return MapTokenizer.newInstance(intrface, token);
            }
            return "{" + token + "}";
        }
    }
}

