/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.utils.request;

import com.kaltura.client.Files;
import com.kaltura.client.Logger;
import com.kaltura.client.types.APIException;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.BaseRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.response.OnCompletion;
import com.kaltura.client.utils.response.base.Response;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class MultiRequestBuilder
extends BaseRequestBuilder<List<Object>, MultiRequestBuilder> {
    private static final String TAG = "MultiRequestBuilder";
    public static final String MULTIREQUEST_ACTION = "multirequest";
    private LinkedHashMap<String, RequestBuilder<?, ?, ?>> requests = new LinkedHashMap();
    private int lastId = 0;

    public MultiRequestBuilder() {
        super(null);
    }

    public MultiRequestBuilder(RequestBuilder<?, ?, ?> ... requests) {
        this();
        this.add(requests);
    }

    public MultiRequestBuilder setCompletion(OnCompletion<Response<List<Object>>> onCompletion) {
        this.onCompletion = onCompletion;
        return this;
    }

    public MultiRequestBuilder add(RequestBuilder<?, ?, ?> ... requests) {
        for (RequestBuilder<?, ?, ?> request : requests) {
            this.add(request);
        }
        return this;
    }

    public MultiRequestBuilder add(RequestBuilder<?, ?, ?> request) {
        ++this.lastId;
        String reqId = this.lastId + "";
        request.params.add("service", request.getService());
        request.params.add("action", request.getAction());
        this.params.add(reqId, request.params);
        if (request.files != null) {
            if (this.files == null) {
                this.files = new Files();
            }
            this.files.add(reqId, request.files);
        }
        this.requests.put(reqId, request);
        request.setId(reqId);
        return this;
    }

    public MultiRequestBuilder add(MultiRequestBuilder multiRequestBuilder) {
        for (String reqId : multiRequestBuilder.requests.keySet()) {
            RequestBuilder<?, ?, ?> request = multiRequestBuilder.requests.get(reqId);
            int last = this.requests.size() + 1;
            this.requests.put(last + "", request);
            this.params.add(last + "", request.params);
        }
        return this;
    }

    @Override
    public void onComplete(Response<List<Object>> response) {
        if (response != null) {
            APIException topError = response.error;
            int index = 0;
            for (RequestBuilder<?, ?, ?> request : this.requests.values()) {
                if (request.onCompletion == null) continue;
                if (topError != null) {
                    request.onComplete((Response<?>)new Response<Object>(null, topError));
                    continue;
                }
                Object item = ((List)response.results).get(index++);
                APIException error = null;
                if (item instanceof APIException) {
                    error = (APIException)item;
                    item = null;
                }
                request.onComplete((Response<?>)new Response(item, error));
            }
        }
        super.onComplete(response);
    }

    @Override
    protected Object parse(String response) throws APIException {
        ArrayList list = new ArrayList();
        for (RequestBuilder<?, ?, ?> call : this.requests.values()) {
            list.add(call.getType());
        }
        return GsonParser.parseArray(response, list.toArray(new Class[this.requests.size()]));
    }

    @Override
    public String getUrlTail() {
        return "service/multirequest";
    }

    public String getAction() {
        return MULTIREQUEST_ACTION;
    }

    public MultiRequestBuilder link(int sourceRequestIdx, int destRequestIdx, String sourceKey, String destKey) {
        try {
            return this.link(this.getRequestAt(sourceRequestIdx), this.getRequestAt(destRequestIdx), sourceKey, destKey);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            Logger.getLogger(TAG).error("failed to link requests. ", e);
            return this;
        }
    }

    public MultiRequestBuilder link(RequestBuilder<?, ?, ?> sourceRequest, RequestBuilder<?, ?, ?> destRequest, String sourceKey, String destKey) {
        if (sourceRequest == null || destRequest == null) {
            throw new NullPointerException("link requests can't be null");
        }
        destRequest.link(destKey, sourceRequest.getId(), sourceKey);
        return this;
    }

    @Override
    public String getTag() {
        return MULTIREQUEST_ACTION;
    }

    private RequestBuilder getRequestAt(int index) throws IndexOutOfBoundsException {
        Object[] requestsKeys = this.requests.keySet().toArray();
        return this.requests.get(requestsKeys[index]);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Tokenizer {
        public Class<?> value();
    }
}

