/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.utils.request;

import com.kaltura.client.types.APIException;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

public abstract class ArrayRequestBuilder<RS, TK, S>
extends RequestBuilder<List<RS>, RequestBuilder.ListTokenizer<TK>, S> {
    private Class<RS> type;

    public ArrayRequestBuilder(Class<RS> type, String service, String action) {
        super(null, service, action);
        this.type = type;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    protected Object parse(String response) throws APIException {
        return GsonParser.parseArray(response, this.type);
    }

    @Override
    public RequestBuilder.ListTokenizer<TK> getTokenizer() throws APIException {
        if (this.id == null) {
            throw new APIException(APIException.FailureStep.OnRequest, "Request is not part of multi-request");
        }
        MultiRequestBuilder.Tokenizer annotation = this.type.getAnnotation(MultiRequestBuilder.Tokenizer.class);
        return new RequestBuilder.ListTokenizer(annotation.value(), this.id + ":result");
    }
}

