/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.utils;

public class ErrorElement {
    public static ErrorElement GeneralError = new ErrorElement("GeneralError", "Something went wrong", 666);
    public static ErrorElement NotFound = new ErrorElement("NotFound", "Resource not found", 404);
    public static ErrorElement LoadError = new ErrorElement("LoadError", "Failed to load data from source", 500);
    public static ErrorElement ServiceUnavailableError = new ErrorElement("ServiceUnavailableError", "Requested service is unavailable", 503);
    public static ErrorElement ConnectionError = new ErrorElement("ConnectionError", "Failed to connect to source", 408);
    public static ErrorElement BadRequestError = new ErrorElement("BadRequestError", "Invalid or missing request params", 400);
    public static ErrorElement SessionError = new ErrorElement("SessionError", "Failed to obtain session", 601);
    public String name;
    private String message;
    private int code;
    protected Object extra;

    public ErrorElement(String name, String message, int code) {
        this(message, code);
        this.name = name;
    }

    public ErrorElement(String message, int code, Object extra) {
        this.message = message;
        this.code = code;
        this.extra = extra;
    }

    public ErrorElement(String message, int code) {
        this(message, code, null);
    }

    public String getMessage() {
        return this.message;
    }

    public ErrorElement message(String message) {
        this.message = message;
        return this;
    }

    public ErrorElement addMessage(String message) {
        this.message = this.message + "; " + message;
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public Object getExtra() {
        return this.extra;
    }

    public static ErrorElement fromCode(int code, String message) {
        switch (code) {
            case 404: {
                return NotFound.message(message);
            }
            case 400: {
                return BadRequestError.message(message);
            }
        }
        return new ErrorElement(message, code);
    }

    public static ErrorElement fromException(Exception exception) {
        switch (exception.getClass().getSimpleName()) {
            case "SocketTimeoutException": 
            case "UnknownHostException": {
                return ConnectionError;
            }
        }
        return GeneralError;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.name != null) {
            builder.append("Error: ").append(this.name).append("; ");
        }
        builder.append("code:").append(this.code).append(", Message:").append(this.message);
        return builder.toString();
    }
}

