/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.VirusFoundAction;
import com.kaltura.client.enums.VirusScanEngineType;
import com.kaltura.client.enums.VirusScanProfileStatus;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BaseEntryFilter;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class VirusScanProfile
extends ObjectBase {
    private Integer id;
    private Long createdAt;
    private Long updatedAt;
    private Integer partnerId;
    private String name;
    private VirusScanProfileStatus status;
    private VirusScanEngineType engineType;
    private BaseEntryFilter entryFilter;
    private VirusFoundAction actionIfInfected;

    public Integer getId() {
        return this.id;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String multirequestToken) {
        this.setToken("name", multirequestToken);
    }

    public VirusScanProfileStatus getStatus() {
        return this.status;
    }

    public void setStatus(VirusScanProfileStatus status) {
        this.status = status;
    }

    public void status(String multirequestToken) {
        this.setToken("status", multirequestToken);
    }

    public VirusScanEngineType getEngineType() {
        return this.engineType;
    }

    public void setEngineType(VirusScanEngineType engineType) {
        this.engineType = engineType;
    }

    public void engineType(String multirequestToken) {
        this.setToken("engineType", multirequestToken);
    }

    public BaseEntryFilter getEntryFilter() {
        return this.entryFilter;
    }

    public void setEntryFilter(BaseEntryFilter entryFilter) {
        this.entryFilter = entryFilter;
    }

    public VirusFoundAction getActionIfInfected() {
        return this.actionIfInfected;
    }

    public void setActionIfInfected(VirusFoundAction actionIfInfected) {
        this.actionIfInfected = actionIfInfected;
    }

    public void actionIfInfected(String multirequestToken) {
        this.setToken("actionIfInfected", multirequestToken);
    }

    public VirusScanProfile() {
    }

    public VirusScanProfile(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.updatedAt = GsonParser.parseLong(jsonObject.get("updatedAt"));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.name = GsonParser.parseString(jsonObject.get("name"));
        this.status = VirusScanProfileStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.engineType = VirusScanEngineType.get(GsonParser.parseString(jsonObject.get("engineType")));
        this.entryFilter = GsonParser.parseObject(jsonObject.getAsJsonObject("entryFilter"), BaseEntryFilter.class);
        this.actionIfInfected = VirusFoundAction.get(GsonParser.parseInt(jsonObject.get("actionIfInfected")));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaVirusScanProfile");
        kparams.add("name", this.name);
        kparams.add("status", this.status);
        kparams.add("engineType", this.engineType);
        kparams.add("entryFilter", this.entryFilter);
        kparams.add("actionIfInfected", this.actionIfInfected);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String createdAt();

        public String updatedAt();

        public String partnerId();

        public String name();

        public String status();

        public String engineType();

        public BaseEntryFilter.Tokenizer entryFilter();

        public String actionIfInfected();
    }
}

