/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.CatalogItemLanguage;
import com.kaltura.client.enums.ReachVendorEngineType;
import com.kaltura.client.enums.VendorCatalogItemStatus;
import com.kaltura.client.enums.VendorServiceFeature;
import com.kaltura.client.enums.VendorServiceTurnAroundTime;
import com.kaltura.client.enums.VendorServiceType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.VendorCatalogItemPricing;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public abstract class VendorCatalogItem
extends ObjectBase {
    private Integer id;
    private Integer vendorPartnerId;
    private String name;
    private String systemName;
    private Long createdAt;
    private Long updatedAt;
    private VendorCatalogItemStatus status;
    private VendorServiceType serviceType;
    private VendorServiceFeature serviceFeature;
    private VendorServiceTurnAroundTime turnAroundTime;
    private VendorCatalogItemPricing pricing;
    private ReachVendorEngineType engineType;
    private CatalogItemLanguage sourceLanguage;
    private Boolean allowResubmission;

    public Integer getId() {
        return this.id;
    }

    public Integer getVendorPartnerId() {
        return this.vendorPartnerId;
    }

    public void setVendorPartnerId(Integer vendorPartnerId) {
        this.vendorPartnerId = vendorPartnerId;
    }

    public void vendorPartnerId(String multirequestToken) {
        this.setToken("vendorPartnerId", multirequestToken);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String multirequestToken) {
        this.setToken("name", multirequestToken);
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void systemName(String multirequestToken) {
        this.setToken("systemName", multirequestToken);
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public VendorCatalogItemStatus getStatus() {
        return this.status;
    }

    public VendorServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(VendorServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public void serviceType(String multirequestToken) {
        this.setToken("serviceType", multirequestToken);
    }

    public VendorServiceFeature getServiceFeature() {
        return this.serviceFeature;
    }

    public VendorServiceTurnAroundTime getTurnAroundTime() {
        return this.turnAroundTime;
    }

    public void setTurnAroundTime(VendorServiceTurnAroundTime turnAroundTime) {
        this.turnAroundTime = turnAroundTime;
    }

    public void turnAroundTime(String multirequestToken) {
        this.setToken("turnAroundTime", multirequestToken);
    }

    public VendorCatalogItemPricing getPricing() {
        return this.pricing;
    }

    public void setPricing(VendorCatalogItemPricing pricing) {
        this.pricing = pricing;
    }

    public ReachVendorEngineType getEngineType() {
        return this.engineType;
    }

    public void setEngineType(ReachVendorEngineType engineType) {
        this.engineType = engineType;
    }

    public void engineType(String multirequestToken) {
        this.setToken("engineType", multirequestToken);
    }

    public CatalogItemLanguage getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(CatalogItemLanguage sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public void sourceLanguage(String multirequestToken) {
        this.setToken("sourceLanguage", multirequestToken);
    }

    public Boolean getAllowResubmission() {
        return this.allowResubmission;
    }

    public void setAllowResubmission(Boolean allowResubmission) {
        this.allowResubmission = allowResubmission;
    }

    public void allowResubmission(String multirequestToken) {
        this.setToken("allowResubmission", multirequestToken);
    }

    public VendorCatalogItem() {
    }

    public VendorCatalogItem(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.vendorPartnerId = GsonParser.parseInt(jsonObject.get("vendorPartnerId"));
        this.name = GsonParser.parseString(jsonObject.get("name"));
        this.systemName = GsonParser.parseString(jsonObject.get("systemName"));
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.updatedAt = GsonParser.parseLong(jsonObject.get("updatedAt"));
        this.status = VendorCatalogItemStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.serviceType = VendorServiceType.get(GsonParser.parseInt(jsonObject.get("serviceType")));
        this.serviceFeature = VendorServiceFeature.get(GsonParser.parseInt(jsonObject.get("serviceFeature")));
        this.turnAroundTime = VendorServiceTurnAroundTime.get(GsonParser.parseInt(jsonObject.get("turnAroundTime")));
        this.pricing = GsonParser.parseObject(jsonObject.getAsJsonObject("pricing"), VendorCatalogItemPricing.class);
        this.engineType = ReachVendorEngineType.get(GsonParser.parseString(jsonObject.get("engineType")));
        this.sourceLanguage = CatalogItemLanguage.get(GsonParser.parseString(jsonObject.get("sourceLanguage")));
        this.allowResubmission = GsonParser.parseBoolean(jsonObject.get("allowResubmission"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaVendorCatalogItem");
        kparams.add("vendorPartnerId", this.vendorPartnerId);
        kparams.add("name", this.name);
        kparams.add("systemName", this.systemName);
        kparams.add("serviceType", this.serviceType);
        kparams.add("turnAroundTime", this.turnAroundTime);
        kparams.add("pricing", this.pricing);
        kparams.add("engineType", this.engineType);
        kparams.add("sourceLanguage", this.sourceLanguage);
        kparams.add("allowResubmission", this.allowResubmission);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String vendorPartnerId();

        public String name();

        public String systemName();

        public String createdAt();

        public String updatedAt();

        public String status();

        public String serviceType();

        public String serviceFeature();

        public String turnAroundTime();

        public VendorCatalogItemPricing.Tokenizer pricing();

        public String engineType();

        public String sourceLanguage();

        public String allowResubmission();
    }
}

