/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.UploadTokenStatus;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class UploadToken
extends ObjectBase {
    private String id;
    private Integer partnerId;
    private String userId;
    private UploadTokenStatus status;
    private String fileName;
    private Double fileSize;
    private Double uploadedFileSize;
    private Long createdAt;
    private Long updatedAt;
    private String uploadUrl;
    private Boolean autoFinalize;
    private String attachedObjectType;
    private String attachedObjectId;

    public String getId() {
        return this.id;
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public String getUserId() {
        return this.userId;
    }

    public UploadTokenStatus getStatus() {
        return this.status;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void fileName(String multirequestToken) {
        this.setToken("fileName", multirequestToken);
    }

    public Double getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Double fileSize) {
        this.fileSize = fileSize;
    }

    public void fileSize(String multirequestToken) {
        this.setToken("fileSize", multirequestToken);
    }

    public Double getUploadedFileSize() {
        return this.uploadedFileSize;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public Boolean getAutoFinalize() {
        return this.autoFinalize;
    }

    public void setAutoFinalize(Boolean autoFinalize) {
        this.autoFinalize = autoFinalize;
    }

    public void autoFinalize(String multirequestToken) {
        this.setToken("autoFinalize", multirequestToken);
    }

    public String getAttachedObjectType() {
        return this.attachedObjectType;
    }

    public String getAttachedObjectId() {
        return this.attachedObjectId;
    }

    public UploadToken() {
    }

    public UploadToken(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseString(jsonObject.get("id"));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.userId = GsonParser.parseString(jsonObject.get("userId"));
        this.status = UploadTokenStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.fileName = GsonParser.parseString(jsonObject.get("fileName"));
        this.fileSize = GsonParser.parseDouble(jsonObject.get("fileSize"));
        this.uploadedFileSize = GsonParser.parseDouble(jsonObject.get("uploadedFileSize"));
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.updatedAt = GsonParser.parseLong(jsonObject.get("updatedAt"));
        this.uploadUrl = GsonParser.parseString(jsonObject.get("uploadUrl"));
        this.autoFinalize = GsonParser.parseBoolean(jsonObject.get("autoFinalize"));
        this.attachedObjectType = GsonParser.parseString(jsonObject.get("attachedObjectType"));
        this.attachedObjectId = GsonParser.parseString(jsonObject.get("attachedObjectId"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaUploadToken");
        kparams.add("fileName", this.fileName);
        kparams.add("fileSize", this.fileSize);
        kparams.add("autoFinalize", this.autoFinalize);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String partnerId();

        public String userId();

        public String status();

        public String fileName();

        public String fileSize();

        public String uploadedFileSize();

        public String createdAt();

        public String updatedAt();

        public String uploadUrl();

        public String autoFinalize();

        public String attachedObjectType();

        public String attachedObjectId();
    }
}

