/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.SessionType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class SessionInfo
extends ObjectBase {
    private String ks;
    private SessionType sessionType;
    private Integer partnerId;
    private String userId;
    private Long expiry;
    private String privileges;

    public String getKs() {
        return this.ks;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Long getExpiry() {
        return this.expiry;
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public SessionInfo() {
    }

    public SessionInfo(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.ks = GsonParser.parseString(jsonObject.get("ks"));
        this.sessionType = SessionType.get(GsonParser.parseInt(jsonObject.get("sessionType")));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.userId = GsonParser.parseString(jsonObject.get("userId"));
        this.expiry = GsonParser.parseLong(jsonObject.get("expiry"));
        this.privileges = GsonParser.parseString(jsonObject.get("privileges"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaSessionInfo");
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String ks();

        public String sessionType();

        public String partnerId();

        public String userId();

        public String expiry();

        public String privileges();
    }
}

