/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.SchedulerConfig;
import com.kaltura.client.types.SchedulerStatus;
import com.kaltura.client.types.SchedulerWorker;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class Scheduler
extends ObjectBase {
    private Integer id;
    private Integer configuredId;
    private String name;
    private String host;
    private List<SchedulerStatus> statuses;
    private List<SchedulerConfig> configs;
    private List<SchedulerWorker> workers;
    private Long createdAt;
    private Integer lastStatus;
    private String lastStatusStr;

    public Integer getId() {
        return this.id;
    }

    public Integer getConfiguredId() {
        return this.configuredId;
    }

    public void setConfiguredId(Integer configuredId) {
        this.configuredId = configuredId;
    }

    public void configuredId(String multirequestToken) {
        this.setToken("configuredId", multirequestToken);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String multirequestToken) {
        this.setToken("name", multirequestToken);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void host(String multirequestToken) {
        this.setToken("host", multirequestToken);
    }

    public List<SchedulerStatus> getStatuses() {
        return this.statuses;
    }

    public List<SchedulerConfig> getConfigs() {
        return this.configs;
    }

    public List<SchedulerWorker> getWorkers() {
        return this.workers;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Integer getLastStatus() {
        return this.lastStatus;
    }

    public String getLastStatusStr() {
        return this.lastStatusStr;
    }

    public Scheduler() {
    }

    public Scheduler(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.configuredId = GsonParser.parseInt(jsonObject.get("configuredId"));
        this.name = GsonParser.parseString(jsonObject.get("name"));
        this.host = GsonParser.parseString(jsonObject.get("host"));
        this.statuses = GsonParser.parseArray(jsonObject.getAsJsonArray("statuses"), SchedulerStatus.class);
        this.configs = GsonParser.parseArray(jsonObject.getAsJsonArray("configs"), SchedulerConfig.class);
        this.workers = GsonParser.parseArray(jsonObject.getAsJsonArray("workers"), SchedulerWorker.class);
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.lastStatus = GsonParser.parseInt(jsonObject.get("lastStatus"));
        this.lastStatusStr = GsonParser.parseString(jsonObject.get("lastStatusStr"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaScheduler");
        kparams.add("configuredId", this.configuredId);
        kparams.add("name", this.name);
        kparams.add("host", this.host);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String configuredId();

        public String name();

        public String host();

        public RequestBuilder.ListTokenizer<SchedulerStatus.Tokenizer> statuses();

        public RequestBuilder.ListTokenizer<SchedulerConfig.Tokenizer> configs();

        public RequestBuilder.ListTokenizer<SchedulerWorker.Tokenizer> workers();

        public String createdAt();

        public String lastStatus();

        public String lastStatusStr();
    }
}

